
<?php $__env->startSection('title','Customer'); ?>
<?php $__env->startSection('content'); ?>
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Customer</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Customer</a></li>
                                    <li class="active">Data Customer</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Customer</strong>
                            </div>
                            <div class="card-body">
                                <?php echo $__env->make('include.admin.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <a href="<?php echo e(route('customer.create')); ?>" class="btn btn-primary mb-3">Tambah</a>
                                
                                <table id="bootstrap-data-table" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Customer</th>
                                            <th>Telp</th>
                                            <th>Email</th>
                                            <th>Alamat</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $customer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                 <td><?php echo e($loop->iteration); ?></td>
                                                 
                                                 <td><?php echo e($value->nama_customer); ?></td>
                                                 <td><?php echo e($value->telp); ?></td>
                                                 <td><?php echo e($value->email); ?></td>
                                                 <td><?php echo e($value->alamat); ?></td>
                                                
                                                
                                                 <td>
                                                     <form method="POST" action="<?php echo e(route('customer.destroy', ['customer' => $value->id])); ?>">
                                                        <div class="btn-group">
                                    
                                                            <a href="<?php echo e(route('customer.edit', $value->id)); ?>" class="btn btn-warning"><i class="fa fa-edit"></i></a>
                                                           
                                                                <?php echo method_field('DELETE'); ?>
                                                                <?php echo csrf_field(); ?>
                                                                <button style="margin-left: 10px;" onclick="return confirm('Apakah anda yakin?')" class="btn btn-danger"><i class="fa fa-trash-o"></i></button>
                                                           
                                                        </div>
                                                     </form>
                                                 </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laragon\www\gib\resources\views/master/customer/index.blade.php ENDPATH**/ ?>