@extends('layouts.master')
@section('title','Penjualan')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Hak Akses</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Setting User</a></li>
                                    <li class="active"><a href="#">Hak Akses</a></li>
                                    
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Hak Akses User</strong>
                            </div>
                            <div class="card-body">
                                <form method="GET" action="{{ url()->current() }}">
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">User</label></div>
                                        <div class="col-12 col-md-9">
                                            <select name="id_user" class="form-control" onchange="this.form.submit()">
                                                <option value="">-- Pilih --</option>
                                                @foreach ($user as $users)
                                                    <option {{ request()->get('id_user') == $users->id?'selected':'' }} value="{{ $users->id }}">{{ $users->nama_lengkap }}</option>                                                    
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    
                                </form>
                                @if (request()->get('id_user'))
                                @php
                                 $setting = array();   
                                @endphp
                                @foreach ($setting_user as $akses)
                                    @php
                                        $setting[$akses['menu']] = $akses['level'];   
                                    @endphp
                                @endforeach
                                <form action="{{ route('setting_user.store') }}" method="post" enctype="multipart/form-data" class="form-horizontal">
                                    @csrf
                                    <input type="hidden" name="id_user" value="{{ request()->get('id_user') }}">
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Master >> Nomor Akun</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="nomor_akun">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['nomor_akun'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['nomor_akun'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Master >> User</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="user">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['user'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['user'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Setting Akses</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="setting_user">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['setting_user'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['setting_user'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Pembelian</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="pembelian">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['pembelian'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['pembelian'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Penjualan</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="penjualan">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['penjualan'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['penjualan'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Penerimaan</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="penerimaan">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['penerimaan'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['penerimaan'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Pengeluaran</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="pengeluaran">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['pengeluaran'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['pengeluaran'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Jurnal Umum</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="jurnal_umum">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['jurnal_umum'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['jurnal_umum'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Neraca Awal</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="neraca_awal">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['neraca_awal'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['neraca_awal'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Neraca Saldo</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="neraca_saldo">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['neraca_saldo'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['neraca_saldo'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Laporan >> Laba Rugi</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="laba_rugi">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['laba_rugi'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['laba_rugi'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Laporan >> Neraca</label></div>
                                        <div class="col-12 col-md-5">
                                            <input type="hidden" name="data_post[menu][]" value="neraca">
                                            <select name="data_post[level][]" class="form-control">
                                                <option {{ ($setting['neraca'] ?? 0) == 0 ? 'selected' : '' }} value="0">Tidak Bisa Akses</option>
                                                <option {{ ($setting['neraca'] ?? 0) == 3 ? 'selected' : '' }} value="3">Bisa Akses</option>
                                            </select>
                                        </div>
                                    </div>

                                    <button type="submit" class="btn btn-primary">
                                        Simpan
                                    </button>
                                </form>
                                @endif
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<script>
  $(document).ready(function() {
    var t = $('#dataTable').DataTable({
        processing: true,
        serverSide: true,
       
        ajax: {
            url: "{{ route('penjualan.getData') }}",
            data: function (d) {
                d.month = $('input[name="month"]').val(); // Ambil nilai dari input form
            }
        },
        columns: [
            {
                data: null,
                name: 'rownum',
                orderable: false,
                searchable: false,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'action', name: 'action', orderable: false, searchable: false },
            { data: 'tanggal', name: 'tanggal' },
            { data: 'no_faktur', name: 'no_faktur' },
            { data: 'keterangan', name: 'keterangan' },
            { data: 'ref', name: 'ref' },
            { data: 'piutang_dagang', name: 'piutang_dagang', className: 'text-right' },
            { data: 'penjualan', name: 'penjualan', className: 'text-right' },
            { data: 'biaya_angkut', name: 'biaya_angkut', className: 'text-right' },
            { data: 'ppn_keluaran', name: 'ppn_keluaran', className: 'text-right' },
            { data: 'discount', name: 'discount', className: 'text-right'}
            
        ]
    });
});



</script>
@endsection
@endsection