@extends('layouts.master')
@section('title','Penjualan')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Penjualan</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Pembelian</a></li>
                                    <li class="active">Data Penjualan</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Penjualan</strong>
                            </div>
                            <div class="card-body">
                                <form method="get">
                                    <div class="row">

                                        <div class="col-md-2">
                                            <input type="month" name="month" class="form-control" value="<?= request()->get('month')?request()->get('month'):date('Y-m') ?>" required>
                                        </div>



                                        <div class="col-md-1">
                                            <button class="btn btn-primary">Cari</button>
                                        </div>

                                        <div class="col-md-1">
                                            <a href="{{ route('penjualan.export.excel', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-success">Export Excel</a>

                                        </div>
                                        <div class="col-md-1">
                                            <a href="{{ route('penjualan.export.pdf', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-danger" target="_blank">Export PDF</a>
                                        </div>
                                    </div>
                                </form>
                                <a href="{{ route('penjualan.create') }}" class="btn btn-primary mb-3">Tambah</a>
                                
                                <table id="dataTable" class="table table-striped table-bordered">
                                    <thead>
                                        
                                        <tr>
                                            <th rowspan="2">No.</th>
                                            <th rowspan="2">Aksi</th>
                                            <th rowspan="2">Tanggal</th>
                                            <th rowspan="2">No.&nbsp;Faktur</th>
                                            <th rowspan="2">Keterangan</th>
                                            <th rowspan="2">Pos&nbsp;Ref</th>
                                            <th colspan="1" style="text-align: center;">Debit</th>
                                            <th colspan="5" style="text-align: center;">Kredit</th>
                                        </tr>
                                        <tr>
                                            <th>Piutang&nbsp;Dagang</th>
                                            <th>Penjualan</th>
                                            <th>Biaya&nbsp;Angkut</th>
                                            <th>PPN&nbsp;Keluaran</th>
                                            <th>Discount</th>
                                            <th>PPH Final</th>
                                        </tr>
                                        
                                    </thead>
                                   
                                </table>
                                
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<script>
  $(document).ready(function() {
    var t = $('#dataTable').DataTable({
        processing: true,
        serverSide: true,
       
        ajax: {
            url: "{{ route('penjualan.getData') }}",
            data: function (d) {
                d.month = $('input[name="month"]').val(); // Ambil nilai dari input form
            }
        },
        columns: [
            {
                data: null,
                name: 'rownum',
                orderable: false,
                searchable: false,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'action', name: 'action', orderable: false, searchable: false },
            { data: 'tanggal', name: 'tanggal' },
            { data: 'no_faktur', name: 'no_faktur' },
            { data: 'keterangan', name: 'keterangan' },
            { data: 'ref', name: 'ref' },
            { data: 'piutang_dagang', name: 'piutang_dagang', className: 'text-right' },
            { data: 'penjualan', name: 'penjualan', className: 'text-right' },
            { data: 'biaya_angkut', name: 'biaya_angkut', className: 'text-right' },
            { data: 'ppn_keluaran', name: 'ppn_keluaran', className: 'text-right' },
            { data: 'discount', name: 'discount', className: 'text-right'},
            { data: 'pph_nominal', name: 'pph_nominal', className: 'text-right' }
            
        ]
    });
});



</script>
@endsection
@endsection