@extends('layouts.master')
@section('title','Penjualan')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Penjualan</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Penjualan</a></li>
                                    <li class="active">Tambah Penjualan</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Tambah Penjualan</strong>
                            </div>
                            <div class="card-body card-block">
                                <form action="{{ route('penjualan.update', ['penjualan' => $data->id]) }}" method="post" enctype="multipart/form-data" class="form-horizontal">
                                    @csrf
                                    @method('PUT')
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Tanggal</label></div>
                                        <div class="col-12 col-md-4">
                                           <input type="date" class="form-control"  name="tanggal" value="{{ $data->tanggal }}">
                                        </div>
                                    </div>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">No. Faktur</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" name="no_faktur" placeholder="No. Faktur" value="{{ $data->no_faktur }}">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Keterangan</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" name="keterangan" placeholder="Keterangan" value="{{ $data->keterangan }}">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Pos Ref</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" name="ref" placeholder="Pos Ref" value="{{ $data->ref }}">
                                        </div>
                                    </div>

                                    <hr>
                                    <h5>Kredit</h5>
                                    <hr>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Penjualan</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" id="penjualan" onkeyup="hitungTotal()" class="form-control" name="penjualan" value="{{ number_format($data->penjualan, 0, ',', '.') }}">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Biaya Angkut</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                             <input type="text" class="form-control" onkeyup="hitungTotal()" id="biaya_angkut" name="biaya_angkut" value="{{ number_format($data->biaya_angkut, 0, ',', '.') }}">
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">PPN Keluaran</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" id="ppn_keluaran" name="ppn_keluaran" value="{{ number_format($data->ppn_keluaran, 0, ',', '.') }}" readonly>
                                        </div>
                                        <div class="col-12 col-md-2">
                                            
                                           <select name="ppn" id="ppn_persen" onchange="hitungTotal()" class="form-control">
                                            <option value="0">0%</option>
                                            <option {{ $data->ppn == 10?'selected':'' }} value="10">10%</option>
                                            <option {{ $data->ppn == 11?'selected':'' }} value="11">11%</option>
                                            <option {{ $data->ppn == 12?'selected':'' }} value="12">12%</option>
                                           </select>
                                        </div>
                                    </div>

                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Discount (%)</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="number" class="form-control" onkeyup="hitungTotal()" name="discount" id="discount"  value="{{ $data->discount }}">
                                            <input type="hidden" name="nominal_diskon" id="nominal_diskon" value="{{ number_format($data->nominal_diskon, 0, ',', '.') }}">
                                        </div>
                                    </div>

                                   

                                    <hr>
                                    <h5>Debit</h5>
                                    <hr>
                                     <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">PPH Final</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" onkeyup="hitungTotal()" name="pph_nominal" id="pph_nominal" value="{{ number_format($data->pph_nominal, 0, ',', '.') }}">
                                           
                                        </div>
                                    </div>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Potongan Lain</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                            <input type="text" class="form-control" onkeyup="hitungTotal()" name="potongan_lain" id="potongan_lain" value="{{ number_format($data->potongan_lain, 0, ',', '.') }}">
                                           
                                        </div>
                                    </div>
                                    <div class="row form-group">
                                        <div class="col col-md-3"><label for="text-input" class=" form-control-label">Piutang Dagang</label></div>
                                        <div class="col-12 col-md-6">
                                            
                                             <input type="text" class="form-control" id="piutang_dagang" name="piutang_dagang" value="{{ number_format($data->piutang_dagang, 0, ',', '.') }}" readonly>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-primary">
                                        Simpan
                                    </button>
                                    <a href="{{ route('penjualan.index') }}" class="btn btn-default">
                                        Batal
                                    </button>
                                </form>
                            </div>
                           
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<!-- Summernote CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.css" rel="stylesheet">
<!-- Summernote JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote-lite.min.js"></script>

<script>
    

    function formatRupiah(angka) {
        let number_string = angka.replace(/[^,\d]/g, "").toString(),
            split = number_string.split(","),
            sisa  = split[0].length % 3,
            rupiah  = split[0].substr(0, sisa),
            ribuan  = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            let separator = sisa ? "." : "";
            rupiah += separator + ribuan.join(".");
        }
        return split[1] !== undefined ? rupiah + "," + split[1] : rupiah;
    }

    function parseRupiah(nilai) {
        return parseInt(nilai.replace(/\./g, "").replace(/[^0-9]/g, '')) || 0;
    }

    function hitungTotal() {
        let penjualan = parseRupiah(document.getElementById('penjualan').value);
        let biaya = parseRupiah(document.getElementById('biaya_angkut').value);
        let discount_persen = parseFloat(document.getElementById('discount').value) || 0;
        let ppn_persen = parseInt(document.getElementById('ppn_persen').value) || 0;
        let pph_nominal = parseRupiah(document.getElementById('pph_nominal').value) || 0;
        let potongan_lain = parseRupiah(document.getElementById('potongan_lain').value) || 0;
        // Hitung diskon berdasarkan persen
        let discount = Math.round((penjualan * discount_persen) / 100);

        let total_sebelum_ppn = penjualan - discount + biaya;
        let ppn = Math.round((total_sebelum_ppn * ppn_persen) / 100);
        let total = total_sebelum_ppn + ppn - pph_nominal - potongan_lain;

        // Format input saat ketik
        document.getElementById('penjualan').value = formatRupiah(penjualan.toString());
        document.getElementById('biaya_angkut').value = formatRupiah(biaya.toString());
        document.getElementById('nominal_diskon').value = formatRupiah(discount.toString());
        document.getElementById('pph_nominal').value = formatRupiah(pph_nominal.toString());
        document.getElementById('potongan_lain').value = formatRupiah(potongan_lain.toString());
        
        // Jangan format discount karena input persen (misal: 10)
        // document.getElementById('discount').value = discount_persen; 

        // Tampilkan hasil
        document.getElementById('ppn_keluaran').value = formatRupiah(ppn.toString());
        document.getElementById('piutang_dagang').value = formatRupiah(total.toString());
    }

</script>
@endsection       


@endsection