@extends('layouts.master')
@section('title','Pembelian')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Pembelian</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Pembelian</a></li>
                                    <li class="active">Data Pembelian</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Pembelian</strong>
                            </div>
                            <div class="card-body">
                                
                                <form method="get">
                                    <div class="row">

                                        <div class="col-md-2">
                                            <input type="month" name="month" class="form-control" value="<?= request()->get('month')?request()->get('month'):date('Y-m') ?>" required>
                                        </div>



                                        <div class="col-md-1">
                                            <button class="btn btn-primary">Cari</button>
                                        </div>

                                        <div class="col-md-1">
                                            <a href="{{ route('pembelian.export.excel', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-success">Export Excel</a>

                                        </div>
                                        <div class="col-md-1">
                                            <a href="{{ route('pembelian.export.pdf', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-danger" target="_blank">Export PDF</a>
                                        </div>
                                    </div>
                                </form>
                                <a href="{{ route('pembelian.create') }}" class="btn btn-primary mb-3">Tambah</a>
                                
                                <table id="dataTable" class="table table-striped table-bordered">
                                    <thead>
                                        
                                        <tr>
                                            <th rowspan="2">No</th>
                                            <th rowspan="2">Aksi</th>
                                            <th rowspan="2">Tanggal</th>
                                            <th rowspan="2">No.&nbsp;Faktur</th>
                                            <th rowspan="2">Keterangan</th>
                                            <th rowspan="2">Pos&nbsp;Ref</th>
                                            <th colspan="4" style="text-align: center;">Debit</th>
                                            <th colspan="1" style="text-align: center;">Kredit</th>
                                            

                                        </tr>
                                        <tr>
                                            <th>Biaya&nbsp;Angkut</th>
                                            <th>PPN&nbsp;Masukan</th>
                                            <th>Pembelian</th>
                                            <th>Discount</th>
                                            <th>Hutang&nbsp;Dagang</th>
                                        </tr>
                                        
                                    </thead>
                                   
                                </table>
                                
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<script>
  $(document).ready(function() {
    var t = $('#dataTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('pembelian.getData') }}",
            data: function (d) {
                d.month = $('input[name="month"]').val(); // Ambil nilai dari input form
            }
        },
        columns: [
            {
                data: null,
                name: 'rownum',
                orderable: false,
                searchable: false,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'action', name: 'action', orderable: false, searchable: false },
            { data: 'tanggal', name: 'tanggal' },
            { data: 'no_faktur', name: 'no_faktur' },
            { data: 'keterangan', name: 'keterangan' },
            { data: 'ref', name: 'ref' },
            { data: 'biaya_angkut', name: 'biaya_angkut', className: 'text-right' },
            
            { data: 'ppn_masukan', name: 'ppn_masukan', className: 'text-right' },
            { data: 'persediaan_barang', name: 'persediaan_barang', className: 'text-right' },
            { data: 'discount', name: 'discount', className: 'text-right'},
            { data: 'hutang_dagang', name: 'hutang_dagang', className: 'text-right' }
        ]
    });
});



</script>
@endsection
@endsection