@extends('layouts.master')
@section('title','Neraca Awal')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Neraca Awal</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    {{-- <li><a href="#">Master</a></li> --}}
                                    <li><a href="#">Neraca Awal</a></li>
                                    <li class="active">Data Neraca Awal</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Neraca Awal</strong>
                            </div>
                            <div class="card-body">
                                <form method="get">
                                    <div class="row">

                                        <div class="col-md-4">
                                            <select name="year" class="form-control" required>
                                                <option value="">-- Pilih Tahun --</option>
                                                @php
                                                    $selectedYear = request()->get('year')?request()->get('year'):date('Y');
                                                @endphp
                                                @for ($year = date('Y'); $year >= 2000; $year--)
                                                    <option value="{{ $year }}" {{ $year == $selectedYear ? 'selected' : '' }}>
                                                        {{ $year }}
                                                    </option>
                                                @endfor
                                                
                                            </select>
                                        </div>



                                        <div class="col-md-2">
                                            <button class="btn-sm btn-primary">Cari</button>
                                        </div>

                                        <div class="col-2">
                                            <a href="{{ route('neraca_awal.export.excel', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-success">Export Excel</a>

                                        </div>
                                        <div class="col-2">
                                            <a href="{{ route('neraca_awal.export.pdf', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-danger" target="_blank">Export PDF</a>
                                        </div>
                                    </div>
                                </form>
                              
                                @php
                                    $debet = 0;
                                    $kredit = 0;
                                    $total_debet = 0;
                                    $total_kredit = 0;
                                    $i = 0;  
                                @endphp
                                <form action="{{ route('neraca_awal.store') }}" method="post" enctype="multipart/form-data" class="form-horizontal">
                                    @csrf
                                    <table id="dataTable" class="table table-striped table-bordered">
                                        <thead>
                                            
                                        <tr>
                                            <th>No</th>
                                            <th>Nomor Akun</th>
                                            <th>Nama Akun</th>
                                            <th>Debet</th>
                                            <th>Kredit</th>
                                        </tr>
                                            
                                        </thead>
                                        <tbody>
                                            @foreach ($master_akun as $akun)

                                                @php
                                                $debet_neraca = 0;
                                                $kredit_neraca = 0;
                                                $i++;   
                                                @endphp
                                                @foreach ($data as $data_neraca)
                                                    @if ($data_neraca['no_akun'] == $akun['no_akun'])
                                                        @php
                                                            $debet_neraca += $data_neraca['debet'];
                                                            $kredit_neraca += $data_neraca['kredit'];;   
                                                        @endphp
                                                    @endif
                                                @endforeach

                                                @php
                                                $debet_penerimaan = 0;
                                                $kredit_penerimaan = 0;   
                                                @endphp
                                                @foreach ($penerimaan as $data_penerimaan)
                                                    @if ($data_penerimaan['no_akun'] == $akun['no_akun'])
                                                        @php
                                                            $debet_penerimaan += $data_penerimaan['debet'];
                                                            $kredit_penerimaan += $data_penerimaan['kredit'];;   
                                                        @endphp
                                                    @endif
                                                @endforeach

                                                @php
                                                $debet_pengeluaran = 0;
                                                $kredit_pengeluaran = 0;   
                                                @endphp
                                                @foreach ($pengeluaran as $data_pengeluaran)
                                                    @if ($data_pengeluaran['no_akun'] == $akun['no_akun'])
                                                        @php
                                                            $debet_pengeluaran += $data_pengeluaran['debet'];
                                                            $kredit_pengeluaran += $data_pengeluaran['kredit'];;   
                                                        @endphp
                                                    @endif
                                                @endforeach

                                                @php
                                                $debet_jurnal = 0;
                                                $kredit_jurnal = 0;   
                                                @endphp
                                                @foreach ($jurnal_umum as $data_jurnal)
                                                    @if ($data_jurnal['no_akun'] == $akun['no_akun'])
                                                        @php
                                                            $debet_jurnal += $data_jurnal['debet'];
                                                            $kredit_jurnal += $data_jurnal['kredit'];;   
                                                        @endphp
                                                    @endif
                                                @endforeach

                                                @php
                                                $debet_neraca_sebelumnya = 0;
                                                $kredit_neraca_sebelumnya = 0;   
                                                @endphp
                                                @foreach ($neraca_awal_sebelumnya as $neraca_sebelumnya)
                                                    @if ($neraca_sebelumnya['no_akun'] == $akun['no_akun'])
                                                        @php
                                                            $debet_neraca_sebelumnya += $neraca_sebelumnya['debet'];
                                                            $kredit_neraca_sebelumnya += $neraca_sebelumnya['kredit'];;   
                                                        @endphp
                                                    @endif
                                                @endforeach
                                                @php
                                                $debet = $debet_penerimaan + $debet_pengeluaran + $debet_jurnal + $debet_neraca_sebelumnya + $debet_neraca;
                                                $kredit = $kredit_penerimaan + $kredit_pengeluaran + $kredit_jurnal + $kredit_neraca_sebelumnya + $kredit_neraca; 
                                                $total_debet += $debet;
                                                $total_kredit += $kredit;  
                                                @endphp
                                                <tr>
                                                    <td><?=$i?></td>
                                                    <td>
                                                        <input type="hidden" name="data_post[no_akun][]" value="{{ $akun->no_akun }}">
                                                        <?=$akun['no_akun']?>
                                                    </td>
                                                    <td>
                                                        <?=$akun['nama_akun']?>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="data_post[debet][]" onkeyup="formatNumber(this); calculateTotal();" class="form-control debet-input" value="{{ number_format($debet, 0, ',', '.') }}">
                                                    </td>
                                                    <td>
                                                        <input type="text" name="data_post[kredit][]" onkeyup="formatNumber(this); calculateTotal();" class="form-control kredit-input" value="{{ number_format($kredit, 0, ',', '.') }}">
                                                    </td>
                                                </tr>
                                            @endforeach
                                            <tr>
                                                <td>
                                                    {{ $i }}
                                                </td>
                                                <td>
                                                    &nbsp;
                                                </td>
                                                <td>
                                                    Total
                                                </td>
                                                <td><input type="text" class="form-control" id="total-debet" value="{{ number_format($total_debet, 0, ',', '.') }}" readonly></td>
                                                <td><input type="text" class="form-control" id="total-kredit"  value="{{ number_format($total_kredit, 0, ',', '.') }}" readonly></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <div id="debet-kredit-warning" style="color: red; display: none;">
                                        Total Debet dan Kredit harus sama.
                                    </div>
                                    <button type="submit" id="btn-simpan" class="btn btn-primary">Simpan</button>
                                </form>
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<script>
$(document).ready(function() {
    $('#dataTable').DataTable({
        paging: false,       // Nonaktifkan pagination
        searching: true,     // Aktifkan fitur pencarian
        info: false
    });
});
function formatNumber(input) {
    let value = input.value.replace(/\./g, '').replace(/[^0-9]/g, '');
    if (value === '') {
        input.value = '';
        return;
    }
    input.value = parseInt(value).toLocaleString('id-ID');
}

function unformat(value) {
    return parseInt(value.replace(/\./g, '')) || 0;
}

function calculateTotal() {
    let totalDebet = 0;
    let totalKredit = 0;

    document.querySelectorAll('.debet-input').forEach(function(input) {
        totalDebet += unformat(input.value);
        console.log(totalDebet);
        
    });

    document.querySelectorAll('.kredit-input').forEach(function(input) {
        totalKredit += unformat(input.value);
    });

    document.getElementById('total-debet').value = totalDebet.toLocaleString('id-ID');
    document.getElementById('total-kredit').value = totalKredit.toLocaleString('id-ID');

    const warning = document.getElementById('debet-kredit-warning');
    const btnSimpan = document.getElementById('btn-simpan');

    if (totalDebet !== totalKredit) {
        warning.style.display = 'block';
        btnSimpan.style.display = 'none';
    } else {
        warning.style.display = 'none';
        btnSimpan.style.display = 'inline-block';
    }
}
</script>
@endsection
@endsection