@extends('layouts.master')
@section('title','Neraca Saldo')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Neraca Saldo</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    {{-- <li><a href="#">Master</a></li> --}}
                                    <li><a href="#">Neraca Saldo</a></li>
                                    <li class="active">Data Neraca Saldo</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Neraca Saldo</strong>
                            </div>
                            <div class="card-body">
                                <form method="get">
                                    <div class="row">

                                        <div class="col-md-4">
                                            <select name="year" class="form-control" required>
                                                <option value="">-- Pilih Tahun --</option>
                                                @php
                                                    $selectedYear = request()->get('year')?request()->get('year'):date('Y');
                                                @endphp
                                                @for ($year = date('Y'); $year >= 2000; $year--)
                                                    <option value="{{ $year }}" {{ $year == $selectedYear ? 'selected' : '' }}>
                                                        {{ $year }}
                                                    </option>
                                                @endfor
                                                
                                            </select>
                                        </div>

                                       


                                        <div class="col-md-2">
                                            <button class="btn-sm btn-primary">Cari</button>
                                        </div>

                                        <div class="col-2">
                                            <a href="{{ route('neraca_saldo.export.excel', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-success">Export Excel</a>
                                        </div>
                                        <div class="col-2">
                                            <a href="{{ route('neraca_saldo.export.pdf', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-danger" target="_blank">Export PDF</a>
                                        </div>
                                    </div>
                                </form>
                              
                                @php
                                    $debet = 0;
                                    $kredit = 0;
                                    $total_debet = 0;
                                    $total_kredit = 0;
                                    $i = 0;  
                                @endphp
                                
                                   <table id="dataTable" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>Nomor Akun</th>
                                            <th>Nama Akun</th>
                                            <th>Debet</th>
                                            <th>Kredit</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $i = 1;
                                            $total_debet = 0;
                                            $total_kredit = 0;
                                        @endphp

                                        @foreach ($master_akun as $akun)
                                            @php
                                                $no_akun = $akun->no_akun;

                                                $debet =
                                                    ($data[$no_akun]->debet ?? 0) +
                                                    ($penerimaan[$no_akun]->debet ?? 0) +
                                                    ($pengeluaran[$no_akun]->debet ?? 0) +
                                                    ($jurnal_umum[$no_akun]->debet ?? 0) +
                                                    ($neraca_awal_sebelumnya[$no_akun]->debet ?? 0);

                                                $kredit =
                                                    ($data[$no_akun]->kredit ?? 0) +
                                                    ($penerimaan[$no_akun]->kredit ?? 0) +
                                                    ($pengeluaran[$no_akun]->kredit ?? 0) +
                                                    ($jurnal_umum[$no_akun]->kredit ?? 0) +
                                                    ($neraca_awal_sebelumnya[$no_akun]->kredit ?? 0);

                                                $total_debet += $debet;
                                                $total_kredit += $kredit;
                                            @endphp

                                            <tr>
                                                <td>{{ $i++ }}</td>
                                                <td>{{ $akun->no_akun }}</td>
                                                <td>{{ $akun->nama_akun }}</td>
                                                <td>{{ number_format($debet, 0, ',', '.') }}</td>
                                                <td>{{ number_format($kredit, 0, ',', '.') }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr class="font-weight-bold">
                                            <td colspan="3" class="text-center">Total</td>
                                            <td>{{ number_format($total_debet, 0, ',', '.') }}</td>
                                            <td>{{ number_format($total_kredit, 0, ',', '.') }}</td>
                                        </tr>
                                    </tfoot>
                                </table>

                                   
                               
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<script>
$(document).ready(function() {
    $('#dataTable').DataTable({
        paging: false,       // Nonaktifkan pagination
        searching: true,     // Aktifkan fitur pencarian
        info: false
    });
});
function formatNumber(input) {
    let value = input.value.replace(/\./g, '').replace(/[^0-9]/g, '');
    if (value === '') {
        input.value = '';
        return;
    }
    input.value = parseInt(value).toLocaleString('id-ID');
}

function unformat(value) {
    return parseInt(value.replace(/\./g, '')) || 0;
}

function calculateTotal() {
    let totalDebet = 0;
    let totalKredit = 0;

    document.querySelectorAll('.debet-input').forEach(function(input) {
        totalDebet += unformat(input.value);
        console.log(totalDebet);
        
    });

    document.querySelectorAll('.kredit-input').forEach(function(input) {
        totalKredit += unformat(input.value);
    });

    document.getElementById('total-debet').value = totalDebet.toLocaleString('id-ID');
    document.getElementById('total-kredit').value = totalKredit.toLocaleString('id-ID');

    const warning = document.getElementById('debet-kredit-warning');
    const btnSimpan = document.getElementById('btn-simpan');

    if (totalDebet !== totalKredit) {
        warning.style.display = 'block';
        btnSimpan.style.display = 'none';
    } else {
        warning.style.display = 'none';
        btnSimpan.style.display = 'inline-block';
    }
}
</script>
@endsection
@endsection