@extends('layouts.master')
@section('title','Neraca')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Neraca</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Neraca</a></li>
                                    <li class="active">Data Neraca</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Neraca</strong>
                            </div>
                            <div class="card-body">
                               
                                <form method="get">
                                    <div class="row">

                                        <div class="col-md-4">
                                            <input type="month" name="month" class="form-control" value="<?= request()->get('month') ?>" required>
                                        </div>



                                        <div class="col-md-2">
                                            <button class="btn-sm btn-primary">Cari</button>
                                        </div>

                                        <div class="col-2">
                                            <a href="{{ route('neraca.export.excel', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-success">Export Excel</a>
                                        </div>
                                        <div class="col-2">
                                            <a href="{{ route('neraca.export.pdf', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-danger" target="_blank">Export PDF</a>
                                        </div>
                                    </div>
                                </form>
                                @php
                                //$total_net_sales = ($penjualan->penjualan + $penjualan->biaya_angkut) - $penjualan->nominal_diskon;
                                $total_net_sales = 0;
                                //$total_net_sales = ($penjualan->penjualan + $penjualan->biaya_angkut+ $penjualan->ppn_keluaran) - $penjualan->nominal_diskon;
                                $total_cogs = 0;
                                //$total_cogs = ($pembelian->persediaan_barang + $pembelian->biaya_angkut) - $pembelian->nominal_diskon;
                                //$total_cogs = ($pembelian->persediaan_barang + $pembelian->biaya_angkut + $pembelian->ppn_masukan) - $pembelian->nominal_diskon;
                                $laba_kotor = $total_net_sales - $total_cogs;
                                $total_current_asset = 0;
                                $total_fixed_asset = 0;
                                $total_current_liabilities = 0;
                                $total_long_term_liabilities = 0;
                                $total_equity = 0;
                                $sum_debet_current_asset = 0;  
                                $sum_kredit_current_asset = 0;
                                $sum_debet_fixed_asset = 0;  
                                $sum_kredit_fixed_asset = 0; 
                                $sum_debet_akumulasi_asset = 0;  
                                $sum_kredit_akumulasi_asset = 0; 
                                $sum_debet_current = 0;  
                                $sum_kredit_current = 0; 
                                $sum_debet_long = 0;  
                                $sum_kredit_long = 0;  
                                
                                $total_net_sales = ($penjualan->penjualan + $penjualan->biaya_angkut) - $penjualan->nominal_diskon;
                                $total_cogs = ($pembelian->persediaan_barang + $pembelian->biaya_angkut) - $pembelian->nominal_diskon;
                                $laba_kotor = $total_net_sales - $total_cogs;   
                                
                                // hitung total beban
                                $total_expenses = 0;
                                foreach ($header_coa as $header) {
                                    if ($header->tipe_akun == 'Beban' || $header->tipe_akun == 'Beban Lain-Lain') {
                                        foreach ($header->masterCoa as $coa) {
                                            $total_debet = 
                                                $coa->penerimaanDebet->sum('debet') +
                                                $coa->pengeluaranDebet->sum('debet') +
                                                $coa->jurnalUmumDebet->sum('debet') +
                                                $coa->neraca_awal->sum('debet');

                                            $total_kredit = 
                                                $coa->penerimaanKredit->sum('kredit') +
                                                $coa->pengeluaranKredit->sum('kredit') +
                                                $coa->jurnalUmumKredit->sum('kredit') +
                                                $coa->neraca_awal->sum('kredit');

                                            $saldo = $total_debet - $total_kredit;
                                            $total_expenses += $saldo;
                                        }
                                    }
                                }

                                // hitung total bunga (akun tipe Bunga)
                                $total_bunga = 0;
                                foreach ($header_coa as $header) {
                                    if ($header->tipe_akun == 'Bunga') {
                                        foreach ($header->masterCoa as $coa) {
                                            $total_debet = 
                                                $coa->penerimaanDebet->sum('debet') +
                                                $coa->pengeluaranDebet->sum('debet') +
                                                $coa->jurnalUmumDebet->sum('debet') +
                                                $coa->neraca_awal->sum('debet');

                                            $total_kredit = 
                                                $coa->penerimaanKredit->sum('kredit') +
                                                $coa->pengeluaranKredit->sum('kredit') +
                                                $coa->jurnalUmumKredit->sum('kredit') +
                                                $coa->neraca_awal->sum('kredit');

                                            $saldo = $total_debet - $total_kredit;
                                            $total_bunga += $saldo;
                                        }
                                    }
                                }

                                // hitung pendapatan lain-lain
                                $total_other_income = 0;
                                foreach ($header_coa as $header) {
                                    if ($header->tipe_akun == 'Pendapatan Lain') {
                                        foreach ($header->masterCoa as $coa) {
                                            $total_debet = 
                                                $coa->penerimaanDebet->sum('debet') +
                                                $coa->pengeluaranDebet->sum('debet') +
                                                $coa->jurnalUmumDebet->sum('debet') +
                                                $coa->neraca_awal->sum('debet');

                                            $total_kredit = 
                                                $coa->penerimaanKredit->sum('kredit') +
                                                $coa->pengeluaranKredit->sum('kredit') +
                                                $coa->jurnalUmumKredit->sum('kredit') +
                                                $coa->neraca_awal->sum('kredit');

                                            $saldo = $total_kredit - $total_debet; // pendapatan normalnya kredit
                                            $total_other_income += $saldo;
                                        }
                                    }
                                }

                                $total_expense_and_other_income = $total_expenses + $total_other_income;

                                // Net Profit
                                $net_profit = ($laba_kotor - $total_expenses) + $total_other_income;
                                @endphp
                                <table class="table table-striped">
                                    <tr>
                                        <th colspan="2" class="text-center">Aktiva</th>
                                    </tr>
                                    <tr>
                                        <th colspan="2">Current assets :</th>
                                        @if (false)
                                            <th>Debet</th>
                                            <th>Kredit</th>
                                        @endif
                                    </tr>
                                    @foreach ($header_coa as $header)
                                        @if ($header->tipe_akun == 'Kas/Bank' || $header->tipe_akun == 'Akun Piutang' || $header->tipe_akun == 'Aktiva Lancar Lainnya')
                                            
                                        
                                        {{-- <tr>
                                            <td colspan="2">{{ $header->nama_header_akun }}</td>
                                        </tr> --}}
                                            @foreach ($header->masterCoa as $coa)
                                                @php
                                                    $total_debet = 
                                                        $coa->penerimaanDebet->sum('debet') +
                                                        $coa->pengeluaranDebet->sum('debet') +
                                                        $coa->jurnalUmumDebet->sum('debet') +
                                                        $coa->neraca_awal->sum('debet');

                                                    $total_kredit = 
                                                        $coa->penerimaanKredit->sum('kredit') +
                                                        $coa->pengeluaranKredit->sum('kredit') +
                                                        $coa->jurnalUmumKredit->sum('kredit') +
                                                        $coa->neraca_awal->sum('kredit');

                                                    $saldo_debet = $total_debet;
                                                    $saldo_kredit = $total_kredit;
                                                    $sum_debet_current_asset += $total_debet;
                                                    $sum_kredit_current_asset += $total_kredit;
                                                    //echo 'debet '.$total_debet.'<br/>';
                                                    //echo $total_kredit.'<br/>';
                                                @endphp
                                                @if ($saldo_debet != 0 or $saldo_kredit != 0)
                                                @php
                                                    $total_current_asset += abs($saldo_debet - $saldo_kredit);
                                                @endphp
                                                    <tr>
                                                        <td>
                                                            {{ $coa->nama_akun }}
                                                        </td>
                                                        <td>{{ number_format(abs($saldo_debet - $saldo_kredit), 0, ',', '.') }}</td>
                                                        @if (false)
                                                            <td><?= number_format(abs($saldo_debet), 0, ',', '.') ?></td>
                                                            <td><?= number_format(abs($saldo_kredit), 0, ',', '.') ?></td>
                                                        @endif
                                                    </tr>
                                                @endif
                                            @endforeach
                                        @endif
                                    @endforeach
                                    @if (false)
                                    <tr>
                                        <td colspan="2"></td>
                                        
                                        <td><?=$sum_debet_current_asset?></td>
                                        <td><?=$sum_kredit_current_asset?></td>
                                       
                                    </tr>
                                    @endif
                                    @php
                                        //$total_current_asset = abs($sum_debet_current_asset - $sum_kredit_current_asset);     
                                    @endphp
                                    @if ($total_current_asset)
                                    <tr>
                                        <th></th>
                                        <th>{{ number_format(abs($total_current_asset), 0, ',', '.') }}</th>
                                    </tr>
                                    @endif
                                    
                                    <tr>
                                        <th colspan="2">Fixed assets :</th>
                                    </tr>
                                    @foreach ($header_coa as $header)
                                        @if ($header->tipe_akun == 'Aktiva Tetap')
                                            
                                        
                                        {{-- <tr>
                                            <td colspan="2">{{ $header->nama_header_akun }}</td>
                                        </tr> --}}
                                            @foreach ($header->masterCoa as $coa)
                                                @php
                                                    $total_debet = 
                                                        $coa->penerimaanDebet->sum('debet') +
                                                        $coa->pengeluaranDebet->sum('debet') +
                                                        $coa->jurnalUmumDebet->sum('debet') +
                                                        $coa->neraca_awal->sum('debet');

                                                    $total_kredit = 
                                                        $coa->penerimaanKredit->sum('kredit') +
                                                        $coa->pengeluaranKredit->sum('kredit') +
                                                        $coa->jurnalUmumKredit->sum('kredit') +
                                                        $coa->neraca_awal->sum('kredit');

                                                    $saldo_debet = $total_debet;
                                                    $saldo_kredit = $total_kredit;
                                                    $sum_debet_fixed_asset += $total_debet;
                                                    $sum_kredit_fixed_asset += $total_kredit;
                                                    //echo 'debet '.$total_debet.'<br/>';
                                                    //echo $total_kredit.'<br/>';
                                                @endphp
                                                @if ($saldo_debet != 0 or $saldo_kredit != 0)
                                                    <tr>
                                                        <td>
                                                            {{ $coa->nama_akun }}
                                                        </td>
                                                        <td>{{ number_format(abs($saldo_debet - $saldo_kredit), 0, ',', '.') }}</td>
                                                        @if (false)
                                                            <td><?= $saldo_debet ?></td>
                                                            <td><?= $saldo_kredit ?></td>
                                                        @endif
                                                    </tr>
                                                @endif
                                            @endforeach
                                        @endif
                                    @endforeach
                                    @php
                                    
                                        $total_fixed_asset = abs($sum_debet_fixed_asset - $sum_kredit_fixed_asset);;     
                                    @endphp
                                    @if ($total_fixed_asset)
                                        <tr>
                                            <th></th>
                                            <th>{{ number_format(abs($total_fixed_asset), 0, ',', '.') }}</th>
                                        </tr>
                                    @endif
                                    @if (false)
                                    <tr>
                                        <td colspan="2"></td>
                                        
                                            <td><?=$sum_debet_fixed_asset?></td>
                                            <td><?=$sum_kredit_fixed_asset?></td>
                                        
                                    </tr>
                                    @endif
                                    <tr>
                                        <th colspan="2">Akumulasi :</th>
                                    </tr>
                                    @foreach ($header_coa as $header)
                                        @if ($header->tipe_akun == 'Akumulasi')
                                            
                                        
                                        {{-- <tr>
                                            <td colspan="2">{{ $header->nama_header_akun }}</td>
                                        </tr> --}}
                                            @foreach ($header->masterCoa as $coa)
                                                @php
                                                    $total_debet = 
                                                        $coa->penerimaanDebet->sum('debet') +
                                                        $coa->pengeluaranDebet->sum('debet') +
                                                        $coa->jurnalUmumDebet->sum('debet') +
                                                        $coa->neraca_awal->sum('debet');

                                                    $total_kredit = 
                                                        $coa->penerimaanKredit->sum('kredit') +
                                                        $coa->pengeluaranKredit->sum('kredit') +
                                                        $coa->jurnalUmumKredit->sum('kredit') +
                                                        $coa->neraca_awal->sum('kredit');

                                                    $saldo_debet = $total_debet;
                                                    $saldo_kredit = $total_kredit;
                                                    $sum_debet_akumulasi_asset += $total_debet;
                                                    $sum_kredit_akumulasi_asset += $total_kredit;
                                                    //echo 'debet '.$total_debet.'<br/>';
                                                    //echo $total_kredit.'<br/>';
                                                @endphp
                                                @if ($saldo_debet != 0 or $saldo_kredit != 0)
                                                    <tr>
                                                        <td>
                                                            {{ $coa->nama_akun }}
                                                        </td>
                                                        <td>{{ number_format(abs($saldo_debet - $saldo_kredit), 0, ',', '.') }}</td>
                                                        @if (false)
                                                            <td><?= $saldo_debet ?></td>
                                                            <td><?= $saldo_kredit ?></td>
                                                        @endif
                                                    </tr>
                                                @endif
                                            @endforeach
                                        @endif
                                    @endforeach
                                    @php
                                    
                                        $total_akumulasi = abs($sum_debet_akumulasi_asset - $sum_kredit_akumulasi_asset);;     
                                    @endphp
                                    @php
                                     $total_fix_akumulasi = $total_fixed_asset -  $total_akumulasi;  
                                    @endphp
                                    @if ($total_akumulasi)
                                        <tr>
                                            <th></th>
                                            <th>{{ number_format(abs($total_akumulasi), 0, ',', '.') }}</th>
                                        </tr>
                                    @endif
                                    @if ($total_fix_akumulasi)
                                        <tr>
                                            <th>Total Aset</th>
                                            <th>{{ number_format(abs($total_fix_akumulasi), 0, ',', '.') }}</th>
                                        </tr>
                                    @endif
                                    @php
                                     $total_aktiva = $total_current_asset + $total_fix_akumulasi;
                                    @endphp

                                    @if ($total_aktiva)
                                        <tr>
                                            <th>Total Aktiva</th>
                                            <th>{{ number_format(abs($total_aktiva), 0, ',', '.') }}</th>
                                        </tr>
                                    @endif
                                    <tr>
                                        <th colspan="2" class="text-center">Passiva</th>
                                    </tr>
                                    <tr>
                                        <th colspan="2">Current liabilities :</th>
                                    </tr>
                                    @foreach ($header_coa as $header)
                                        @if ($header->tipe_akun == 'Akun Hutang Lancar' || $header->tipe_akun == 'Hutang Lancar Lainnya')
                                            
                                        
                                        {{-- <tr>
                                            <td colspan="2">{{ $header->nama_header_akun }}</td>
                                        </tr> --}}
                                            @foreach ($header->masterCoa as $coa)
                                                @php
                                                    $total_debet = 
                                                        $coa->penerimaanDebet->sum('debet') +
                                                        $coa->pengeluaranDebet->sum('debet') +
                                                        $coa->jurnalUmumDebet->sum('debet') +
                                                        $coa->neraca_awal->sum('debet');

                                                    $total_kredit = 
                                                        $coa->penerimaanKredit->sum('kredit') +
                                                        $coa->pengeluaranKredit->sum('kredit') +
                                                        $coa->jurnalUmumKredit->sum('kredit') +
                                                        $coa->neraca_awal->sum('kredit');

                                                    $saldo_debet = $total_debet;
                                                    $saldo_kredit = $total_kredit;
                                                    $sum_debet_current += $total_debet;
                                                    $sum_kredit_current += $total_kredit;
                                                @endphp
                                                @if ($saldo_debet != 0 or $saldo_kredit != 0)
                                               
                                                    <tr>
                                                        <td>
                                                            {{ $coa->nama_akun }}
                                                        </td>
                                                        <td>{{ number_format(abs($saldo_debet - $saldo_kredit), 0, ',', '.') }}</td>
                                                        @if (false)
                                                            <td><?= $saldo_debet ?></td>
                                                            <td><?= $saldo_kredit ?></td>
                                                        @endif
                                                    </tr>
                                                @endif
                                            @endforeach
                                        @endif
                                    @endforeach
                                    @php
                                        $total_current_liabilities = abs($sum_debet_current - $sum_kredit_current);     
                                    @endphp
                                    @if (false)
                                    <tr>
                                        <td colspan="2"></td>
                                        
                                            <td><?=$sum_debet_current?></td>
                                            <td><?=$sum_kredit_current?></td>
                                        
                                    </tr>
                                    @endif
                                    @if ($total_current_liabilities)
                                    <tr>
                                        <th></th>
                                        <th>{{ number_format(abs($total_current_liabilities), 0, ',', '.') }}</th>
                                    </tr>
                                    @endif
                                    <tr>
                                        <th colspan="2">Long term liabilities :</th>
                                    </tr>
                                    @foreach ($header_coa as $header)
                                        @if ($header->tipe_akun == 'Hutang Jangka')
                                            
                                        
                                        {{-- <tr>
                                            <td colspan="2">{{ $header->nama_header_akun }}</td>
                                        </tr> --}}
                                            @foreach ($header->masterCoa as $coa)
                                                @php
                                                    $total_debet = 
                                                        $coa->penerimaanDebet->sum('debet') +
                                                        $coa->pengeluaranDebet->sum('debet') +
                                                        $coa->jurnalUmumDebet->sum('debet') +
                                                        $coa->neraca_awal->sum('debet');

                                                    $total_kredit = 
                                                        $coa->penerimaanKredit->sum('kredit') +
                                                        $coa->pengeluaranKredit->sum('kredit') +
                                                        $coa->jurnalUmumKredit->sum('kredit') +
                                                        $coa->neraca_awal->sum('kredit');

                                                    $saldo_debet = $total_debet;
                                                    $saldo_kredit = $total_kredit;
                                                    $sum_debet_long += $total_debet;
                                                    $sum_kredit_long += $total_kredit;
                                                @endphp
                                                @if ($saldo_debet != 0 || $saldo_kredit != 0)
                                               
                                                    <tr>
                                                        <td>
                                                            {{ $coa->nama_akun }}
                                                        </td>
                                                        <td>{{ number_format(abs($saldo_debet - $saldo_kredit), 0, ',', '.') }}</td>
                                                        @if (false)
                                                        <td><?= $saldo_debet ?></td>
                                                        <td><?= $saldo_kredit ?></td>
                                                        @endif()
                                                    </tr>
                                                @endif
                                            @endforeach
                                        @endif
                                    @endforeach
                                    @php
                                        $total_long_term_liabilities = abs($sum_debet_long - $sum_kredit_long);     
                                    @endphp
                                    @if (false)
                                        <tr>
                                            <td colspan="2"></td>
                                            
                                            <td><?=$sum_debet_long?></td>
                                            <td><?=$sum_kredit_long?></td>
                                            
                                        </tr>
                                    @endif
                                    @if ($total_long_term_liabilities)
                                        <tr>
                                            <th></th>
                                            <th>{{ number_format(abs($total_long_term_liabilities), 0, ',', '.') }}</th>
                                        </tr>
                                    @endif
                                    <tr>
                                        <th colspan="2">Equity :</th>
                                    </tr>
                                    @foreach ($header_coa as $header)
                                        @if ($header->tipe_akun == 'Ekuitas')
                                            
                                        
                                        {{-- <tr>
                                            <td colspan="2">{{ $header->nama_header_akun }}</td>
                                        </tr> --}}
                                            @foreach ($header->masterCoa as $coa)
                                                @php
                                                    $total_debet = 
                                                        $coa->penerimaanDebet->sum('debet') +
                                                        $coa->pengeluaranDebet->sum('debet') +
                                                        $coa->jurnalUmumDebet->sum('debet') +
                                                        $coa->neraca_awal->sum('debet');

                                                    $total_kredit = 
                                                        $coa->penerimaanKredit->sum('kredit') +
                                                        $coa->pengeluaranKredit->sum('kredit') +
                                                        $coa->jurnalUmumKredit->sum('kredit')+
                                                        $coa->neraca_awal->sum('kredit');

                                                    $saldo = $total_debet - $total_kredit;
                                                    //echo 'debet '.$total_debet.'<br/>';
                                                    //echo $total_kredit.'<br/>';
                                                @endphp
                                                @if ($saldo != 0)
                                                @php
                                                    $total_equity += abs($saldo);     
                                                @endphp
                                                    <tr>
                                                        <td>
                                                            {{ $coa->nama_akun }}
                                                        </td>
                                                        <td>{{ number_format(abs($saldo), 0, ',', '.') }}</td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                            <tr>
                                                <th>Net Profit</th>
                                                <th>{{ number_format(abs($net_profit), 0, ',', '.') }}</th>
                                            </tr>
                                            <tr>
                                                <th>Total Modal</th>
                                                <th>{{ number_format(abs($total_equity + $net_profit), 0, ',', '.') }}</th>
                                            </tr>
                                            @php
                                            $total_modal = $total_equity + $net_profit
                                             //$total_equity += $laba_kotor;   
                                            @endphp
                                        @endif
                                    @endforeach
                                   
                                    <tr>
                                        <th>Total Assets : {{ number_format($total_aktiva, 0, ',', '.') }}</th>
                                        <th>
                                          
                                            Total liabilities & equity : {{  number_format($total_current_liabilities + $total_long_term_liabilities +  $total_modal, 0, ',', '.')}}
                                        </th>
                                    </tr>
                                </table>
                               
                                
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')

@endsection
@endsection