@extends('layouts.master')
@section('title','Laba Rugi')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Neraca</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Neraca</a></li>
                                    <li class="active">Data Neraca</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Neraca</strong>
                            </div>
                            <div class="card-body">
                               
                                <form method="get">
                                    <div class="row">

                                        <div class="col-md-4">
                                            <input type="month" name="month" class="form-control" value="<?= request()->get('month') ?>" required>
                                        </div>



                                        <div class="col-md-2">
                                            <button class="btn-sm btn-primary">Cari</button>
                                        </div>

                                        <div class="col-2">
                                            <a href="{{ route('neraca.export.excel', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-success">Export Excel</a>
                                        </div>
                                        <div class="col-2">
                                            <a href="{{ route('neraca.export.pdf', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-danger" target="_blank">Export PDF</a>
                                        </div>
                                    </div>
                                </form>
                                @forelse ($headerLabaRugi as $header)

                                    @php
                                        // Filter akun yang punya transaksi
                                        $coas = $header->masterCoa->filter(fn($coa) =>
                                            ((float) $coa->debet  ?? 0) != 0 ||
                                            ((float) $coa->kredit ?? 0) != 0
                                        );

                                        if ($coas->isEmpty()) continue;

                                        $totalDebet  = 0;
                                        $totalKredit = 0;
                                        $totalSaldo  = 0;
                                    @endphp
                                    @foreach ($coas as $coa)
                                        @php
                                            $debet  = (float) ($coa->debet  ?? 0);
                                            $kredit = (float) ($coa->kredit ?? 0);
                                            $saldo  = abs($debet - $kredit);

                                            $totalDebet  += $debet;
                                            $totalKredit += $kredit;
                                            $totalSaldo  += $saldo;
                                        @endphp
                                        @php
                                            // simpan total saldo per header untuk kebutuhan net profit
                                            $totalSaldoArr[$header->nama_header_akun] = $totalSaldo;
                                            $netProfit =
                                                ($totalSaldoArr['PENDAPATAN USAHA']            ?? 0)
                                            - ($totalSaldoArr['Gaji & Tunjangan Karyawan']   ?? 0)
                                            - ($totalSaldoArr['Biaya Penyusutan & Amortisasi'] ?? 0)
                                            - ($totalSaldoArr['Biaya Sewa']                  ?? 0)
                                            - ($totalSaldoArr['BIAYA ADMINISTRASI UMUM LAINNYA'] ?? 0)
                                            - ($totalSaldoArr['BIAYA OPERASIONAL ARMADA TRANSPORTASI'] ?? 0)
                                            + ($totalSaldoArr['PENDAPATAN DILUAR USAHA']     ?? 0)
                                            - ($totalSaldoArr['BIAYA DILUAR USAHA']          ?? 0)
                                            - ($totalSaldoArr['BIAYA KONSTRUKSI']            ?? 0);
                                        @endphp
                                    @endforeach
                            @empty
                                
                            @endforelse
                               @forelse ($headerNeraca as $header)

                                    @php
                                        // Ambil hanya COA yang punya debet atau kredit > 0
                                        $coas = $header->masterCoa->filter(function ($coa) {
                                            return ((float) $coa->debet  ?? 0) != 0
                                                || ((float) $coa->kredit ?? 0) != 0;
                                        });

                                        // Kalau semua nol, skip header ini
                                        if ($coas->isEmpty()) {
                                            continue;
                                        }

                                        $totalDebet  = 0;
                                        $totalKredit = 0;
                                        $totalSaldo  = 0;
                                    @endphp

                                    {{-- Judul Header (Kelompok Akun) --}}
                                    <h5 class="mt-4 mb-2">
                                        {{ $header->nama ?? $header->nama_header_akun ?? 'Kelompok ' . $header->id }}
                                    </h5>

                                    <table class="table table-sm table-bordered align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="width: 140px;">No. Akun</th>
                                                <th>Nama Akun</th>
                                                <th class="text-end" style="width: 160px;">Debet</th>
                                                <th class="text-end" style="width: 160px;">Kredit</th>
                                                <th class="text-end" style="width: 160px;">Saldo</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($coas as $coa)
                                                @php
                                                    $debet  = (float) ($coa->debet  ?? 0);
                                                    $kredit = (float) ($coa->kredit ?? 0);
                                                    $saldo  = $debet - $kredit;   // tidak boleh minus

                                                    $totalDebet  += $debet;
                                                    $totalKredit += $kredit;
                                                    $totalSaldo  += $saldo;
                                                @endphp
                                                <tr>
                                                    <td>{{ $coa->no_akun ?? $coa->kode ?? $coa->id }}</td>
                                                    <td>{{ $coa->nama_akun_ind ?? $coa->nama_akun ?? $coa->nama }}</td>
                                                    <td class="text-end">
                                                        {{ number_format($debet, 0, ',', '.') }}
                                                    </td>
                                                    <td class="text-end">
                                                        {{ number_format($kredit, 0, ',', '.') }}
                                                    </td>
                                                    <td class="text-end">
                                                        {{ number_format($saldo, 0, ',', '.') }}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr class="fw-bold">
                                                <td colspan="2" class="text-end">
                                                    Total {{ $header->nama ?? $header->nama_header_akun ?? 'Kelompok ' . $header->id }}
                                                </td>
                                                <td class="text-end">
                                                    {{ number_format($totalDebet, 0, ',', '.') }}
                                                </td>
                                                <td class="text-end">
                                                    {{ number_format($totalKredit, 0, ',', '.') }}
                                                </td>
                                                <td class="text-end">
                                                    {{ number_format($totalSaldo, 0, ',', '.') }}
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>

                                    @php
                                        // simpan total saldo per header untuk kebutuhan net profit
                                        $totalSaldoArr[$header->nama_header_akun] = $totalSaldo;
                                    @endphp

                                @empty
                                    <div class="alert alert-info">
                                        Tidak ada data neraca / laba rugi untuk periode yang dipilih.
                                    </div>
                                @endforelse

                                   @php
                                        $aktiva =
                                            ($totalSaldoArr['Kas & Bank']                    ?? 0)
                                            + ($totalSaldoArr['Piutang']                       ?? 0)
                                            + ($totalSaldoArr['Pajak Dibayar Di Muka']         ?? 0)
                                            + ($totalSaldoArr['Aktiva Tetap']                  ?? 0)
                                            + ($totalSaldoArr['Akumulasi Depresiasi Aktiva Tetap'] ?? 0);

                                        // Aman dari "undefined index" karena ?? 0 dievaluasi dulu, baru abs()
                                        $hutangLancar        = abs($totalSaldoArr['Hutang Lancar']        ?? 0);
                                        $hutangJangkaPanjang = abs($totalSaldoArr['Hutang Jangka Panjang'] ?? 0);
                                        $modal               = abs($totalSaldoArr['Modal'] ?? 0);

                                        $pasiva = $hutangLancar + $hutangJangkaPanjang + $modal + abs($netProfit);

                                        $totalHutang =
                                            ($totalSaldoArr['Hutang Lancar']        ?? 0)
                                            + ($totalSaldoArr['Hutang Jangka Panjang'] ?? 0);
                                    @endphp

                                <h4 class="mt-4 text-success">
                                    Aktiva: {{ number_format($aktiva, 0, ',', '.') }}
                                </h4>

                                <h4 class="mt-4 text-success">
                                    Passiva: {{ number_format($pasiva, 0, ',', '.') }}
                                </h4>
                               
                                
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')

@endsection
@endsection