@extends('layouts.master')
@section('title','Laba Rugi')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Laba Rugi</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Laba Rugi</a></li>
                                    <li class="active">Data Laba Rugi</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Laba Rugi</strong>
                            </div>
                            <div class="card-body">
                               
                                <form method="get">
                                    <div class="row">

                                        <div class="col-md-4">
                                            <input type="month" name="month" class="form-control" value="<?= request()->get('month') ?>" required>
                                        </div>



                                        <div class="col-md-2">
                                            <button class="btn-sm btn-primary">Cari</button>
                                        </div>

                                        <div class="col-2">
                                            <a href="{{ route('laba_rugi.export.excel', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-success">Export Excel</a>
                                        </div>
                                        <div class="col-2">
                                            <a href="{{ route('laba_rugi.export.pdf', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-danger" target="_blank">Export PDF</a>
                                        </div>
                                    </div>
                                </form>
                                @php
                                $total_net_sales = ($penjualan->penjualan + $penjualan->biaya_angkut) - $penjualan->nominal_diskon;
                                $total_cogs = ($pembelian->persediaan_barang + $pembelian->biaya_angkut) - $pembelian->nominal_diskon;
                                $laba_kotor = $total_net_sales - $total_cogs;   
                                
                                // hitung total beban
                                $total_expenses = 0;
                                foreach ($header_coa as $header) {
                                    if ($header->tipe_akun == 'Beban' || $header->tipe_akun == 'Beban Lain-Lain') {
                                        foreach ($header->masterCoa as $coa) {
                                            $total_debet = 
                                                $coa->penerimaanDebet->sum('debet') +
                                                $coa->pengeluaranDebet->sum('debet') +
                                                $coa->jurnalUmumDebet->sum('debet') +
                                                $coa->neraca_awal->sum('debet');

                                            $total_kredit = 
                                                $coa->penerimaanKredit->sum('kredit') +
                                                $coa->pengeluaranKredit->sum('kredit') +
                                                $coa->jurnalUmumKredit->sum('kredit') +
                                                $coa->neraca_awal->sum('kredit');

                                            $saldo = $total_debet - $total_kredit;
                                            $total_expenses += $saldo;
                                        }
                                    }
                                }

                                // hitung total bunga (akun tipe Bunga)
                                $total_bunga = 0;
                                foreach ($header_coa as $header) {
                                    if ($header->tipe_akun == 'Bunga') {
                                        foreach ($header->masterCoa as $coa) {
                                            $total_debet = 
                                                $coa->penerimaanDebet->sum('debet') +
                                                $coa->pengeluaranDebet->sum('debet') +
                                                $coa->jurnalUmumDebet->sum('debet') +
                                                $coa->neraca_awal->sum('debet');

                                            $total_kredit = 
                                                $coa->penerimaanKredit->sum('kredit') +
                                                $coa->pengeluaranKredit->sum('kredit') +
                                                $coa->jurnalUmumKredit->sum('kredit') +
                                                $coa->neraca_awal->sum('kredit');

                                            $saldo = $total_debet - $total_kredit;
                                            $total_bunga += $saldo;
                                        }
                                    }
                                }

                                // hitung pendapatan lain-lain
                                $total_other_income = 0;
                                foreach ($header_coa as $header) {
                                    if ($header->tipe_akun == 'Pendapatan Lain') {
                                        foreach ($header->masterCoa as $coa) {
                                            $total_debet = 
                                                $coa->penerimaanDebet->sum('debet') +
                                                $coa->pengeluaranDebet->sum('debet') +
                                                $coa->jurnalUmumDebet->sum('debet') +
                                                $coa->neraca_awal->sum('debet');

                                            $total_kredit = 
                                                $coa->penerimaanKredit->sum('kredit') +
                                                $coa->pengeluaranKredit->sum('kredit') +
                                                $coa->jurnalUmumKredit->sum('kredit') +
                                                $coa->neraca_awal->sum('kredit');

                                            $saldo = $total_kredit - $total_debet; // pendapatan normalnya kredit
                                            $total_other_income += $saldo;
                                        }
                                    }
                                }

                                // Net Profit
                                $net_profit = $laba_kotor - $total_expenses - $total_bunga + $total_other_income;   
                                @endphp
                                <table class="table table-striped">
                                    <tr>
                                        <th colspan="2">Revenues :</th>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%">Penjualan barang dagang/Sales</td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($penjualan->penjualan, 0, ',', '.') }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%">Beban Angkut Penjualan/Freight Out</td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($penjualan->biaya_angkut, 0, ',', '.') }}
                                        </td>
                                    </tr>
                                    {{-- <tr>
                                        <td style="width: 50%">PPN Keluaran/Output VAT</td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($penjualan->ppn_keluaran, 0, ',', '.') }}
                                        </td>
                                    </tr> --}}
                                    <tr>
                                        <td style="width: 50%">Potongan penjualan barang dagangang/Sales Discount</td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($penjualan->nominal_diskon, 0, ',', '.') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <td style="width: 50%" class="text-right">Net Sales : </td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($total_net_sales, 0, ',', '.') }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <th colspan="2">Cost of goods sold :</th>
                                    </tr>
                                    @foreach ($header_coa as $header)
                                        @if ($header->tipe_akun == 'Harga Pokok')
                                            @foreach ($header->masterCoa as $coa)
                                                @php
                                                    $total_debet = 
                                                        $coa->penerimaanDebet->sum('debet') +
                                                        $coa->pengeluaranDebet->sum('debet') +
                                                        $coa->jurnalUmumDebet->sum('debet') +
                                                        $coa->neraca_awal->sum('debet');
                                                    //var_dump($coa->neraca_awal->sum('debet'));
                                                    $total_kredit = 
                                                        $coa->penerimaanKredit->sum('kredit') +
                                                        $coa->pengeluaranKredit->sum('kredit') +
                                                        $coa->jurnalUmumKredit->sum('kredit')+
                                                        $coa->neraca_awal->sum('kredit');
                                                    //var_dump($coa->neraca_awal->sum('kredit'));
                                                    $saldo = $total_debet - $total_kredit;
                                                    //echo 'debet '.$total_debet.'<br/>';
                                                    //echo $total_kredit.'<br/>';
                                                @endphp
                                                @if ($saldo != 0)
                                                    <tr>
                                                        <td>
                                                            {{ $coa->nama_akun }}
                                                        </td>
                                                        <td>{{ number_format(abs($saldo), 0, ',', '.') }}</td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        @endif
                                    @endforeach

                                    <tr>
                                        <td style="width: 50%">Pembelian/Purchasing</td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($pembelian->persediaan_barang, 0, ',', '.') }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%">Beban transportasi pembelian/Freight Paid</td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($pembelian->biaya_angkut, 0, ',', '.') }}
                                        </td>
                                    </tr>
                                    {{-- <tr>
                                        <td style="width: 50%">PPN Masukan/Input VAT</td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($pembelian->ppn_masukan, 0, ',', '.') }}
                                        </td>
                                    </tr> --}}
                                    <tr>
                                        <td style="width: 50%">Potongan pembelian barang dagangan/Purchase Discount</td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($pembelian->nominal_diskon, 0, ',', '.') }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%" class="text-right">Total COGS : </td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($total_cogs, 0, ',', '.') }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%" class="text-right">Laba Kotor : </td>
                                        <td style="width: 50%" class="">
                                            {{ number_format($laba_kotor, 0, ',', '.') }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <th colspan="2">Expenses :</th>
                                    </tr>
                                    @foreach ($header_coa as $header)
                                        @if ($header->tipe_akun == 'Beban' || $header->tipe_akun == 'Beban Lain-Lain')
                                            
                                        
                                        {{-- <tr>
                                            <td colspan="2">{{ $header->nama_header_akun }}</td>
                                        </tr> --}}
                                            @foreach ($header->masterCoa as $coa)
                                                @php
                                                    $total_debet = 
                                                        $coa->penerimaanDebet->sum('debet') +
                                                        $coa->pengeluaranDebet->sum('debet') +
                                                        $coa->jurnalUmumDebet->sum('debet') +
                                                        $coa->neraca_awal->sum('debet');
                                                    //var_dump($coa->neraca_awal->sum('debet'));
                                                    $total_kredit = 
                                                        $coa->penerimaanKredit->sum('kredit') +
                                                        $coa->pengeluaranKredit->sum('kredit') +
                                                        $coa->jurnalUmumKredit->sum('kredit')+
                                                        $coa->neraca_awal->sum('kredit');
                                                    //var_dump($coa->neraca_awal->sum('kredit'));
                                                    $saldo = $total_debet - $total_kredit;
                                                    //echo 'debet '.$total_debet.'<br/>';
                                                    //echo $total_kredit.'<br/>';
                                                @endphp
                                                @if ($saldo != 0)
                                                    <tr>
                                                        <td>
                                                            {{ $coa->nama_akun }}
                                                        </td>
                                                        <td>{{ number_format(abs($saldo), 0, ',', '.') }}</td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        @endif
                                    @endforeach
                                    <tr>
                                        <th>Total Expenses :</th>
                                        <th>{{ number_format(abs($total_expenses), 0, ',', '.') }}</th>
                                    </tr>
                                    <tr>
                                        <th>Other revenues and gains :</th>
                                    </tr>
                                   
                                    @foreach ($header_coa as $header)
                                        @if ($header->tipe_akun == 'Pendapatan Lain')
                                            
                                        
                                        {{-- <tr>
                                            <td colspan="2">{{ $header->nama_header_akun }}</td>
                                        </tr> --}}
                                            @foreach ($header->masterCoa as $coa)
                                                @php
                                                    $total_debet = 
                                                        $coa->penerimaanDebet->sum('debet') +
                                                        $coa->pengeluaranDebet->sum('debet') +
                                                        $coa->jurnalUmumDebet->sum('debet') +
                                                        $coa->neraca_awal->sum('debet');
                                                    //var_dump($coa->neraca_awal->sum('debet'));
                                                    $total_kredit = 
                                                        $coa->penerimaanKredit->sum('kredit') +
                                                        $coa->pengeluaranKredit->sum('kredit') +
                                                        $coa->jurnalUmumKredit->sum('kredit')+
                                                        $coa->neraca_awal->sum('kredit');
                                                    //var_dump($coa->neraca_awal->sum('kredit'));
                                                    $saldo = $total_debet - $total_kredit;
                                                    //echo 'debet '.$total_debet.'<br/>';
                                                    //echo $total_kredit.'<br/>';
                                                @endphp
                                                @if ($saldo != 0)
                                                    <tr>
                                                        <td>
                                                            {{ $coa->nama_akun }}
                                                        </td>
                                                        <td>{{ number_format(abs($saldo), 0, ',', '.') }}</td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        @endif
                                    @endforeach
                                    @php
                                     $total_expense_and_other_income = $total_expenses + $total_other_income;
                                    @endphp
                                    <tr>
                                        <th>Total Other Income</th>
                                        <th>{{ number_format(abs($total_other_income), 0, ',', '.') }}</th>
                                    </tr>
                                    
                                    <tr>
                                        <th>Total Bunga :</th>
                                        <td>{{ number_format($total_bunga, 0, ',', '.') }}</td>
                                    </tr>
                                    <tr>
                                        <th>Net Profit :</th>
                                        <td> {{ number_format(($laba_kotor - $total_expenses) + $total_other_income, 0, ',', '.') }}</td>
                                    </tr>
                                </table>
                               
                                
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')

@endsection
@endsection