@extends('layouts.master')
@section('title','Laba Rugi')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Laba Rugi</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Laba Rugi</a></li>
                                    <li class="active">Data Laba Rugi</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Laba Rugi</strong>
                            </div>
                            <div class="card-body">
                               
                                <form method="get">
                                    <div class="row">

                                        <div class="col-md-4">
                                            <input type="month" name="month" class="form-control" value="<?= request()->get('month') ?>" required>
                                        </div>



                                        <div class="col-md-2">
                                            <button class="btn-sm btn-primary">Cari</button>
                                        </div>

                                        <div class="col-2">
                                            <a href="{{ route('laba_rugi.export.excel', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-success">Export Excel</a>
                                        </div>
                                        <div class="col-2">
                                            <a href="{{ route('laba_rugi.export.pdf', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-danger" target="_blank">Export PDF</a>
                                        </div>
                                    </div>
                                </form>
                              @forelse ($headerNeraca as $header)

                                    @php
                                        // Filter akun yang punya transaksi
                                        $coas = $header->masterCoa->filter(fn($coa) =>
                                            ((float) $coa->debet  ?? 0) != 0 ||
                                            ((float) $coa->kredit ?? 0) != 0
                                        );

                                        if ($coas->isEmpty()) continue;

                                        $totalDebet  = 0;
                                        $totalKredit = 0;
                                        $totalSaldo  = 0;
                                    @endphp

                                    {{-- Judul Header --}}
                                    <h5 class="mt-4 mb-2">
                                        {{ $header->nama ?? $header->nama_header_akun ?? 'Kelompok ' . $header->id }}
                                    </h5>

                                    <table class="table table-sm table-bordered align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th>No. Akun</th>
                                                <th>Nama Akun</th>
                                                <th class="text-end">Debet</th>
                                                <th class="text-end">Kredit</th>
                                                <th class="text-end">Saldo</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($coas as $coa)
                                                @php
                                                    $debet  = (float) ($coa->debet  ?? 0);
                                                    $kredit = (float) ($coa->kredit ?? 0);
                                                    $saldo  = abs($debet - $kredit);

                                                    $totalDebet  += $debet;
                                                    $totalKredit += $kredit;
                                                    $totalSaldo  += $saldo;
                                                @endphp
                                                <tr>
                                                    <td>{{ $coa->no_akun ?? $coa->kode ?? $coa->id }}</td>
                                                    <td>{{ $coa->nama_akun_ind ?? $coa->nama_akun ?? $coa->nama }}</td>
                                                    <td class="text-end">{{ number_format($debet, 0, ',', '.') }}</td>
                                                    <td class="text-end">{{ number_format($kredit, 0, ',', '.') }}</td>
                                                    <td class="text-end">{{ number_format($saldo, 0, ',', '.') }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr class="fw-bold">
                                                <td colspan="2" class="text-end">Total {{ $header->nama_header_akun }}</td>
                                                <td class="text-end">{{ number_format($totalDebet, 0, ',', '.') }}</td>
                                                <td class="text-end">{{ number_format($totalKredit, 0, ',', '.') }}</td>
                                                <td class="text-end">{{ number_format($totalSaldo, 0, ',', '.') }}</td>
                                            </tr>
                                        </tfoot>
                                    </table>

                                    @php
                                        // simpan total saldo per header untuk kebutuhan net profit
                                        $totalSaldoArr[$header->nama_header_akun] = $totalSaldo;
                                    @endphp

                                @empty
                                    <div class="alert alert-info">
                                        Tidak ada data neraca / laba rugi untuk periode yang dipilih.
                                    </div>
                                @endforelse

                                {{-- ===================== --}}
                                {{-- HITUNG NET PROFIT     --}}
                                {{-- ===================== --}}
                                @php
                                $netProfit =
                                    ($totalSaldoArr['PENDAPATAN USAHA']            ?? 0)
                                - ($totalSaldoArr['Gaji & Tunjangan Karyawan']   ?? 0)
                                - ($totalSaldoArr['Biaya Penyusutan & Amortisasi'] ?? 0)
                                - ($totalSaldoArr['Biaya Sewa']                  ?? 0)
                                - ($totalSaldoArr['BIAYA ADMINISTRASI UMUM LAINNYA'] ?? 0)
                                - ($totalSaldoArr['BIAYA OPERASIONAL ARMADA TRANSPORTASI'] ?? 0)
                                + ($totalSaldoArr['PENDAPATAN DILUAR USAHA']     ?? 0)
                                - ($totalSaldoArr['BIAYA DILUAR USAHA']          ?? 0)
                                - ($totalSaldoArr['BIAYA KONSTRUKSI']            ?? 0);
                                @endphp

                                <h4 class="mt-4 text-success">
                                    Net Profit: {{ number_format($netProfit, 0, ',', '.') }}
                                </h4>
                               
                                
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')

@endsection
@endsection