@extends('layouts.master')
@section('title','Jurnal Umum')
@section('content')
        
        <div class="breadcrumbs">
            <div class="breadcrumbs-inner">
                <div class="row m-0">
                    <div class="col-sm-4">
                        <div class="page-header float-left">
                            <div class="page-title">
                                <h1>Jurnal Umum</h1>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="page-header float-right">
                            <div class="page-title">
                                <ol class="breadcrumb text-right">
                                    <li><a href="#">Master</a></li>
                                    <li><a href="#">Penerimaan</a></li>
                                    <li class="active">Data Jurnal Umum</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Jurnal Umum</strong>
                            </div>
                            <div class="card-body">
                                <form method="get">
                                    <div class="row">

                                        <div class="col-3">
                                            <input type="month" name="month" class="form-control" value="<?= request()->get('month')?request()->get('month'):date('Y-m') ?>" required>
                                        </div>



                                        <div class="col-1">
                                            <button class="btn btn-primary">Cari</button>
                                        </div>

                                        <div class="col-2">
                                            <a href="{{ route('jurnal_umum.export.excel', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-success">Export Excel</a>

                                        </div>
                                        <div class="col-2">
                                            <a href="{{ route('jurnal_umum.export.pdf', ['month' => request('month', date('Y-m'))]) }}" class="btn btn-danger" target="_blank">Export PDF</a>
                                        </div>
                                    </div>
                                </form>
                                <a href="{{ route('jurnal_umum.create') }}" class="btn btn-primary mb-3">Tambah</a>
                                
                                <table id="dataTable" class="table table-striped table-bordered">
                                    <thead>
                                        
                                        <tr>
                                            <th rowspan="2">No</th>
                                            <th rowspan="2">Aksi</th>
                                            <th rowspan="2">Tanggal</th>
                                            
                                            <th colspan="2" style="text-align: center;">Debit</th>
                                            <th colspan="2" style="text-align: center;">Kredit</th>
                                            

                                        </tr>
                                        <tr>
                                            <th>Nama&nbsp;Akun</th>
                                            <th>Jumlah</th>
                                            <th>Nama&nbsp;Akun</th>
                                            <th>Jumlah</th>
                                            
                                        </tr>
                                        
                                    </thead>
                                   
                                </table>
                                
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<script>
  $(document).ready(function() {
    var t = $('#dataTable').DataTable({
        processing: true,
        serverSide: true,
        
        ajax: {
            url: "{{ route('jurnal_umum.getData') }}",
            data: function (d) {
                d.month = $('input[name="month"]').val(); // Ambil nilai dari input form
            }
        },
        columns: [
            {
                data: null,
                name: 'rownum',
                orderable: false,
                searchable: false,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'action', name: 'action', orderable: false, searchable: false },
            { data: 'tanggal', name: 'tanggal' },
            { data: 'nama_akun_debet', name: 'nama_akun_debet' },
            { data: 'debet', name: 'debet', className: 'text-right' },
            { data: 'nama_akun_kredit', name: 'nama_akun_kredit' },
            { data: 'kredit', name: 'kredit', className: 'text-right' }
        ]
    });
});



</script>
@endsection
@endsection