<?php

namespace App\Exports;


use App\Models\Penjualan;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithMapping;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Events\AfterSheet;

class PenjualanExport implements FromCollection, WithHeadings, WithEvents, WithMapping
{
    protected $month;
    protected $years;
    protected $rowNumber = 0;
    protected $bulanIndonesia;
    public function __construct($month, $years, $bulanIndonesia)
    {
        $this->month = $month;
        $this->years = $years;
        $this->bulanIndonesia = $bulanIndonesia;
    }

    public function collection()
    {
        return Penjualan::select(
            'tanggal',
            'no_faktur',
            'keterangan',
            'ref',
            'piutang_dagang',
            'penjualan',
            'biaya_angkut',
            'ppn_keluaran',
            'discount',
            'pph_nominal'
        )
            ->whereYear('penjualan.tanggal', $this->years)
            ->whereMonth('penjualan.tanggal', $this->month)
            ->get();
    }

    public function map($row): array
    {
        $this->rowNumber++;

        return [
            $this->rowNumber,
            \Carbon\Carbon::parse($row->tanggal)->format('d/m/Y'),
            $row->no_faktur,
            $row->keterangan,
            $row->ref,
            $row->piutang_dagang,
            $row->penjualan,
            $row->biaya_angkut,
            $row->ppn_keluaran,
            $row->discount,
            $row->pph_nominal,
        ];
    }

    public function headings(): array
    {
        return [
            'No',
            'Tanggal',
            'No Faktur',
            'Keterangan',
            'Ref',
            'Piutang Dagang',
            'Penjualan',
            'Biaya Angkut',
            'PPN Keluaran',
            'Discount',
            'PPH Final'
        ];
    }


    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();

                // Insert judul
                $sheet->insertNewRowBefore(1, 3);
                $sheet->setCellValue('A1', 'PT. Berkah Semangat Sentosa');
                $sheet->setCellValue('A2', 'Penjualan Bulan ' . $this->bulanIndonesia . ' Tahun ' . $this->years);
                $sheet->mergeCells('A1:K1');
                $sheet->mergeCells('A2:K2');
                $sheet->getStyle('A1:K2')->getAlignment()->setHorizontal('center');
                $sheet->getStyle('A1')->getFont()->setBold(true)->setSize(14);

                // Header baris 1 (baris 3)
                $sheet->setCellValue('A3', 'No');
                $sheet->setCellValue('B3', 'Tanggal');
                $sheet->setCellValue('C3', 'No. Faktur');
                $sheet->setCellValue('D3', 'Keterangan');
                $sheet->setCellValue('E3', 'Pos Ref');
                $sheet->setCellValue('F3', 'Kredit');
                $sheet->setCellValue('G3', 'Debit');

                $sheet->mergeCells('F3:F4');
                $sheet->mergeCells('G3:K3');

                $sheet->setCellValue('F4', 'Piutang Dagang');
                $sheet->setCellValue('G4', 'Penjualan');
                $sheet->setCellValue('H4', 'Biaya Angkut');
                $sheet->setCellValue('I4', 'PPN Keluaran');
                $sheet->setCellValue('J4', 'Discount');
                $sheet->setCellValue('K4', 'PPH Final');

                foreach (['A', 'B', 'C', 'D', 'E'] as $col) {
                    $sheet->mergeCells("{$col}3:{$col}4");
                }

                // Styling header
                $sheet->getStyle('A3:K4')->getFont()->setBold(true);
                $sheet->getStyle('A3:K4')->getAlignment()->setHorizontal('center');
                $sheet->getStyle('A3:K4')->getAlignment()->setVertical('center');
                $sheet->getStyle('A3:K4')->applyFromArray([
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ],
                    ],
                ]);

                // === Tambahkan border untuk semua baris data ===
                $totalRows = 4 + $this->rowNumber; // 4 header rows + total data
                $sheet->getStyle("A5:K{$totalRows}")->applyFromArray([
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ],
                    ],
                ]);
            }
        ];
    }
}
