<?php

namespace App\Exports;

use App\Models\Pembelian;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Events\AfterSheet;

class PembelianExport implements FromCollection, WithHeadings, WithEvents, WithMapping
{
    protected $month;
    protected $years;
    protected $rowNumber = 0;
    protected $bulanIndonesia;
    public function __construct($month, $years, $bulanIndonesia)
    {
        $this->month = $month;
        $this->years = $years;
        $this->bulanIndonesia = $bulanIndonesia;
    }

    public function collection()
    {
        return Pembelian::select(
            'tanggal',
            'no_faktur',
            'keterangan',
            'ref',
            'biaya_angkut',
            'ppn_masukan',
            'persediaan_barang',
            'discount',
            'hutang_dagang'
        )
            ->whereYear('tanggal', $this->years)
            ->whereMonth('tanggal', $this->month)
            ->get();
    }

    public function map($row): array
    {
        $this->rowNumber++;

        return [
            $this->rowNumber,
            \Carbon\Carbon::parse($row->tanggal)->format('d/m/Y'),
            $row->no_faktur,
            $row->keterangan,
            $row->ref,
            $row->biaya_angkut,
            $row->ppn_masukan,
            $row->persediaan_barang,
            $row->discount,
            $row->hutang_dagang,
        ];
    }

    public function headings(): array
    {
        return [
            'No',
            'Tanggal',
            'No Faktur',
            'Keterangan',
            'Ref',
            'Biaya Angkut',
            'PPN Masukan',
            'Persediaan Barang',
            'Diskon',
            'Hutang Dagang'
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();

                // Insert judul
                $sheet->insertNewRowBefore(1, 3);
                $sheet->setCellValue('A1', 'PT. Berkah Semangat Sentosa');
                $sheet->setCellValue('A2', 'Pembelian Bulan ' . $this->bulanIndonesia . ' Tahun ' . $this->years);
                $sheet->mergeCells('A1:J1');
                $sheet->mergeCells('A2:J2');
                $sheet->getStyle('A1:J2')->getAlignment()->setHorizontal('center');
                $sheet->getStyle('A1')->getFont()->setBold(true)->setSize(14);

                // Header baris 1 (baris 3)
                $sheet->setCellValue('A3', 'No');
                $sheet->setCellValue('B3', 'Tanggal');
                $sheet->setCellValue('C3', 'No. Faktur');
                $sheet->setCellValue('D3', 'Keterangan');
                $sheet->setCellValue('E3', 'Pos Ref');
                $sheet->setCellValue('F3', 'Debit');
                $sheet->setCellValue('J3', 'Kredit');

                $sheet->mergeCells('F3:I3');
                $sheet->mergeCells('J3:J4');

                $sheet->setCellValue('F4', 'Biaya Angkut');
                $sheet->setCellValue('G4', 'PPN Masukan');
                $sheet->setCellValue('H4', 'Pembelian');
                $sheet->setCellValue('I4', 'Diskon');

                foreach (['A', 'B', 'C', 'D', 'E'] as $col) {
                    $sheet->mergeCells("{$col}3:{$col}4");
                }

                // Styling header
                $sheet->getStyle('A3:J4')->getFont()->setBold(true);
                $sheet->getStyle('A3:J4')->getAlignment()->setHorizontal('center');
                $sheet->getStyle('A3:J4')->getAlignment()->setVertical('center');
                $sheet->getStyle('A3:J4')->applyFromArray([
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ],
                    ],
                ]);

                // === Tambahkan border untuk semua baris data ===
                $totalRows = 4 + $this->rowNumber; // 4 header rows + total data
                $sheet->getStyle("A5:J{$totalRows}")->applyFromArray([
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ],
                    ],
                ]);
            }
        ];
    }
}
