<?php

namespace App\Exports;

use App\Models\HeaderCoa;
use App\Models\Penjualan;
use App\Models\Pembelian;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class LabaRugiExport implements FromView
{
    protected $bulan;
    protected $tahun;
    protected $bulanIndonesia;
    public function __construct($tahun, $bulan, $bulanIndonesia)
    {
        $this->tahun = $tahun;
        $this->bulan = $bulan;
        $this->bulanIndonesia = $bulanIndonesia;
    }

    public function view(): View
    {
        $tahun = $this->tahun;
        $bulan = $this->bulan;
        $tahunBulan = $this->tahun . '-' . $this->bulan;
        $bulanIndonesia =  $this->bulanIndonesia;
        $penjualan = Penjualan::selectRaw('
        SUM(piutang_dagang) as piutang_dagang,
        SUM(penjualan) as penjualan,
        SUM(biaya_angkut) as biaya_angkut,
        SUM(nominal_diskon) as nominal_diskon,
        SUM(ppn_keluaran) as ppn_keluaran')
            ->whereRaw("DATE_FORMAT(tanggal, '%Y-%m') = ?", [$tahunBulan])
            ->first();

        $pembelian = Pembelian::selectRaw('
        SUM(hutang_dagang) as hutang_dagang,
        SUM(persediaan_barang) as persediaan_barang,
        SUM(biaya_angkut) as biaya_angkut,
        SUM(nominal_diskon) as nominal_diskon,
        SUM(ppn_masukan) as ppn_masukan')
            ->whereRaw("DATE_FORMAT(tanggal, '%Y-%m') = ?", [$tahunBulan])
            ->first();



        $header_coa = HeaderCoa::with(['masterCoa' => function ($query) use ($tahunBulan, $tahun) {
            $query->with([
                'penerimaanDebet' => function ($q) use ($tahunBulan) {
                    $q->whereRaw("DATE_FORMAT(tanggal, '%Y-%m') = ?", [$tahunBulan]);
                },
                'penerimaanKredit' => function ($q) use ($tahunBulan) {
                    $q->whereRaw("DATE_FORMAT(tanggal, '%Y-%m') = ?", [$tahunBulan]);
                },
                'pengeluaranDebet' => function ($q) use ($tahunBulan) {
                    $q->whereRaw("DATE_FORMAT(tanggal, '%Y-%m') = ?", [$tahunBulan]);
                },
                'pengeluaranKredit' => function ($q) use ($tahunBulan) {
                    $q->whereRaw("DATE_FORMAT(tanggal, '%Y-%m') = ?", [$tahunBulan]);
                },
                'jurnalUmumDebet' => function ($q) use ($tahunBulan) {
                    $q->whereRaw("DATE_FORMAT(tanggal, '%Y-%m') = ?", [$tahunBulan]);
                },
                'jurnalUmumKredit' => function ($q) use ($tahunBulan) {
                    $q->whereRaw("DATE_FORMAT(tanggal, '%Y-%m') = ?", [$tahunBulan]);
                },
                'neraca_awal' => function ($q) use ($tahun) {
                    $q->whereRaw("DATE_FORMAT(tahun, '%Y') = ?", [$tahun]);
                },
            ])->orderBy('no_akun');
        }])->orderBy('no_header_akun')->get();

        return view('laporan.laba_rugi.excel', [
            'header_coa' => $header_coa,
            'bulan' => $bulan,
            'tahun' => $tahun,
            'penjualan' => $penjualan,
            'pembelian' => $pembelian,
            'bulanIndonesia' => $bulanIndonesia
        ]);
    }
}
