<?php


use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AjaxController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\AboutController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\BarangController;
use App\Http\Controllers\LokasiController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\AbsensiController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\KatalogController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SejarahController;
use App\Http\Controllers\TeknisiController;
use App\Http\Controllers\KategoriController;
use App\Http\Controllers\KegiatanController;
use App\Http\Controllers\PengawasController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PenutupanController;
use App\Http\Controllers\UjiFungsiController;
use App\Http\Controllers\KoordinatorController;
use App\Http\Controllers\SdmPelaksanaController;
use App\Http\Controllers\DetailSejarahController;
use App\Http\Controllers\KesiapanLokasiController;
use App\Http\Controllers\LokasiKegiatanController;
use App\Http\Controllers\InstallasiBarangController;
use App\Http\Controllers\PenerimaanBarangController;
use App\Http\Controllers\SetupSdmPengawasController;
use App\Http\Controllers\PelaksanaanHarianController;
use App\Http\Controllers\StrukturOrganisasiController;
use App\Http\Controllers\SetupSdmKoordinatorController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('home');
});

Route::get('/', [HomeController::class, 'index']);
Route::get('/home', [HomeController::class, 'index'])->name('home');
//Route::get('/admin_panel', [AdminController::class, 'index'])->middleware('guest')->name('admin_panel');
Route::post('/authenticate', [AuthController::class, 'authenticate'])->name('authenticate');
Route::get('/register', [AuthController::class, 'form_regist']);
Route::post('/register', [AuthController::class, 'register'])->name('register');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('/admin_panel', [AdminController::class, 'index']);



Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');


Route::group(['middleware' => 'auth'], function () {
    Route::resource('slider', SliderController::class);
    Route::resource('about', AboutController::class);
    Route::resource('contact', ContactController::class);
    Route::resource('katalog', KatalogController::class);
    Route::resource('product', ProductController::class);
});

Route::get('/visi-misi', [AboutController::class, 'visi_misi'])->name('visi_misi');

Route::get('/sejarah-bkn', [SejarahController::class, 'sejarah_bkn'])->name('sejarah_bkn');

Route::get('/struktur-organisasi', [StrukturOrganisasiController::class, 'struktur_organisasi'])->name('struktur_organisasi');

Route::get('/berita-bkn', [NewsController::class, 'berita_bkn'])->name('berita_bkn');

Route::get('/berita-bkn/{id}', [NewsController::class, 'berita_bkn_edit'])->name('berita_bkn.edit');


Route::get('/event-bkn', [EventController::class, 'event_bkn'])->name('event_bkn');

Route::get('/event-bkn/{id}', [EventController::class, 'event_bkn_edit'])->name('event_bkn.edit');

Route::get('/view-produk', [ProductController::class, 'view_produk'])->name('view_produk');

Route::get('/hubungi-kami', [ContactController::class, 'hubungi_kami'])->name('hubungi_kami');
