<?php

namespace App\Http\Controllers;

use App\Models\About;
use App\Models\Slider;
use App\Models\Contact;
use App\Models\Katalog;
use App\Models\Product;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    public function index()
    {
        $contact = Contact::findOrFail(1);
        //dd($sejarah);
        return view('contact.index', compact('contact'));
    }


    public function update(Request $request, $id)
    {

        Contact::where('id', $id)->update($request->except(['_token', '_method']));
        return redirect('contact')->with('alert-success', 'Success Update Data');
    }

    public function hubungi_kami()
    {
        $contact = Contact::all();
        $katalog = Katalog::all();
        $about = About::all();
        $slider = Slider::all();
        $product = Product::all();
        return view('contact.hubungi_kami', compact('contact', 'katalog', 'about', 'slider', 'product'));
    }
}
