<?php

namespace App\Http\Controllers;

use App\Models\About;
use App\Models\Slider;
use App\Models\Contact;
use App\Models\Katalog;
use App\Models\Product;
use Illuminate\Http\Request;

class AboutController extends Controller
{
    public function index()
    {
        $about = About::findOrFail(1);
        //dd($sejarah);
        return view('about.index', compact('about'));
    }


    public function update(Request $request, $id)
    {

        About::where('id', $id)->update($request->except(['_token', '_method']));
        return redirect('about')->with('alert-success', 'Success Update Data');
    }

    public function visi_misi()
    {
        $contact = Contact::all();
        $katalog = Katalog::all();
        $about = About::all();
        $slider = Slider::all();
        $product = Product::all();
        return view('about.visi_misi', compact('contact', 'katalog', 'about', 'slider', 'product'));
    }
}
