<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>ADMIN-ECOEDUPARK</title>
  <link rel="icon" type="image/png" href="{{ asset('favicon.ico')}}">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <!-- Font Awesome v5 -->
  <link href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css" rel="stylesheet">
  <!-- Select2 -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <!-- DataTables -->
  <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
  <link rel="stylesheet" href="{{ asset('plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css')}}">
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
    }

    #sidebar {
      height: 100vh;
      width: 250px;
      position: fixed;
      top: 0;
      left: 0;
      background-color: #1e1e2f;
      color: white;
      overflow-y: auto;
      transition: all 0.3s ease;
      z-index: 1000;
    }

    #sidebar .sidebar-header {
      background-color: #003B8E;
      padding: 20px;
      text-align: center;
    }

    #sidebar .sidebar-header img {
      height: 50px;
    }

    #sidebar ul {
      list-style: none;
      padding: 0;
    }

    #sidebar ul li {
      padding: 10px 20px;
      cursor: pointer;
      color: #ccc;
    }

    #sidebar ul li:hover {
      background-color: #343a40;
      color: white;
    }

    #sidebar ul .submenu {
      display: none;
      padding-left: 15px;
    }

    #sidebar ul .submenu li {
      font-size: 14px;
      padding: 6px 20px;
    }

    #content {
      margin-left: 250px;
      transition: all 0.3s ease;
    }

    .navbar {
      position: sticky;
      top: 0;
      z-index: 999;
      background-color: #fff;
      border-bottom: 1px solid #dee2e6;
    }
    .nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active {
      color: black !important; 
    }

    .sarpras-row label.col-form-label {
      margin-bottom: 21px !important;
    }

    .sarpras-row .btn-remove-sarpras-row {
      margin-bottom: 21px !important;
    }

    /* Responsive */
    @media (max-width: 768px) {
      #sidebar {
        left: -250px;
      }

      #sidebar.active {
        left: 0;
      }

      #content {
        margin-left: 0;
      }

      #content.shifted {
        margin-left: 250px;
      }
    }
    a{
        color: #ccc !important;
        text-decoration:none !important;
    }
    .form-group{
        margin-bottom: 15px !important;
    }
     .select2-container .select2-selection--single {
                height: 38px !important; /* atau 38px untuk Bootstrap 4 */
                padding: 6px 12px;
                border: 1px solid #ccc;
                border-radius: 4px;
            }

            .select2-container--default .select2-selection--single .select2-selection__rendered {
                line-height: 20px;
            }

            .select2-container--default .select2-selection--single .select2-selection__arrow {
                height: 36px;
                right: 6px;
            }
     .card-header{
            background-color: #e6e6e6 !important;
            color: #003B8E !important;
    }
     .btn-primary{
            /* font-size: 13px; */
            background-color:#003B8E !important;
            border-color:#003B8E !important;
            color:white !important;
           }
           .btn-default{
                color:black !important;
            }
            .btn-success{
                color:white !important;
            }
           .btn-warning{
            /* font-size: 13px;
            background-color:#009F9F !important;
            border-color:#009F9F !important; */
            /* color:white !important; */
            color: black !important;
           }
           /* .btn-danger{
            font-size: 13px;
            background-color:#009F9F !important;
            border-color:#009F9F !important;
            color:white !important;
            
           } */
            /* .btn-default{
                color:black !important;
            } */
            .breadcrumbs{
                display: none;
            }
            .text-right{
              text-align: right;
            }

          input[readonly] {
              background-color: #f5f5f5;
              color: #888;
              border: 1px solid #ccc;
              cursor: not-allowed;
          }

          label{
            margin-top:5px;
          }

          .table-responsive {
            width: 100% !important;
            overflow-x: auto !important;
            -webkit-overflow-scrolling: touch;
          }
          @media (max-width: 768px) {
            #transaksiKas {
              min-width: 700px; /* atur sesuai kebutuhan */
            }
          }
  </style>
</head>
<body>

  <!-- Header -->
  @include('include.header')

  <div class="wrapper">
    <!-- Sidebar -->
    @include('include.sidebar')

    <!-- Main Content -->
    <div class="content" id="content" style="padding: 25px;">
      @yield('content')
    </div>
  </div>

  <!-- Scripts -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
  <script src="{{ asset('plugins/sweetalert2/sweetalert2.min.js')}}"></script>
  <script src="https://cdn.jsdelivr.net/npm/autonumeric@4.6.0/dist/autoNumeric.min.js"></script>
  <script>
    function toggleSidebar() {
      const sidebar = document.getElementById('sidebar');
      const content = document.getElementById('content');
      sidebar.classList.toggle('active');
      content.classList.toggle('shifted');
    }

    function toggleSubmenu(id, el) {
      const submenu = document.getElementById('submenu-' + id);
      const icon = el.querySelector('.fa-caret-down, .fa-caret-up'); // ambil ikon caret

      // toggle show/hide submenu
      submenu.style.display = submenu.style.display === 'block' ? 'none' : 'block';

      // toggle caret up/down
      if (submenu.style.display === 'block') {
          icon.classList.remove('fa-caret-down');
          icon.classList.add('fa-caret-up');
      } else {
          icon.classList.remove('fa-caret-up');
          icon.classList.add('fa-caret-down');
      }
    }
    

    $(document).ready(function () {
      $('.select2').select2();
    //   $('#example').DataTable();
    });

    var alertSuccess = {!! json_encode(Session::pull('alert-success')) !!};
    var alertFailed = {!! json_encode(Session::pull('alert-failed')) !!};
    var alertWarning = {!! json_encode(Session::pull('alert-warning')) !!};

    var Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 5000
    });

    if (alertSuccess) {
        Toast.fire({
            icon: 'success',
            title: alertSuccess
        });
    } else if (alertFailed) {
        Toast.fire({
            icon: 'error',
            title: alertFailed
        });
    } else if (alertWarning) {
        Toast.fire({
            icon: 'warning',
            title: alertWarning
        });
    }
  </script>
   @yield('js')
</body>
</html>
