@extends('layouts.master')
@section('title','Komoditi')
@section('content')
        
        
        <!-- Content -->
        <div class="content">
            <div class="animated fadeIn">
                <div class="row">

                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <strong class="card-title">Data Eco Tours</strong>
                            </div>
                            <div class="card-body">
                               
                                <a href="{{ route('eco_tours.create') }}" class="btn btn-primary mb-3">Tambah</a>
                                <div class="table-responsive">
                                <table id="dataTable" class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Nomor Titik</th>
                                            <th>Nama</th>
                                            <th>Koordinat X</th>
                                            <th>Koordinat Y</th>
                                            <th>Keterangan</th>
                                            <th>Gambar</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                   
                                </table>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div><!-- .animated -->
        </div><!-- .content -->
        <!-- /.content -->
@section('js')
<script>
  $(document).ready(function() {
    var t = $('#dataTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('eco_tours.getData') }}",
        columns: [
            {
                data: null,
                name: 'rownum',
                orderable: false,
                searchable: false,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'no', name: 'no' },
            { data: 'tittle', name: 'tittle' },
            { data: 'x', name: 'x' },
            { data: 'y', name: 'y' },
            { data: 'desc', name: 'desc' },
            { data: 'image', name: 'image' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });
});

</script>
@endsection
@endsection