<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\MasterLocations;
use App\Models\MasterProcessType;
use App\Models\WasteTransactions;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Models\MasterWasteCatagories;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon;

class WasteTransactionController extends Controller
{
    public function index()
    {
        return view('waste_transactions.index');
    }

    public function create()
    {
        $lokasi = MasterLocations::all();
        $kategori = MasterWasteCatagories::all();
        $tipe_proses = MasterProcessType::all();

        return view('waste_transactions.create', compact('lokasi', 'kategori', 'tipe_proses'));
    }

    public function edit($id)
    {

        $data = WasteTransactions::findOrFail($id);
        $lokasi = MasterLocations::all();
        $kategori = MasterWasteCatagories::all();
        $tipe_proses = MasterProcessType::all();
        return view('waste_transactions.edit', compact('data', 'lokasi', 'kategori', 'tipe_proses'));
    }





    public function store(Request $request)
    {
        // Ambil data text
        $data = [
            'trx_date'     => $request->trx_date,
            'location_id'     => $request->location_id,
            'category_id'     => $request->category_id,
            'source_type'     => $request->source_type,
            'source_name'     => $request->source_name,
            'direction'     => $request->direction,
            'process_type_id'     => $request->process_type_id,
            'weight_kg'     => $request->weight_kg,
            'operator_name'     => $request->operator_name,
            'notes'     => $request->notes,

        ];



        WasteTransactions::create($data);

        return redirect()
            ->route('waste_transaction.index')
            ->with('alert-success', 'Data berhasil disimpan.');
    }

    public function update(Request $request, $id)
    {
        $waste_categoris = WasteTransactions::findOrFail($id);
        // Update field teks
        $data = [
            'trx_date'     => $request->trx_date,
            'location_id'     => $request->location_id,
            'category_id'     => $request->category_id,
            'source_type'     => $request->source_type,
            'source_name'     => $request->source_name,
            'direction'     => $request->direction,
            'process_type_id'     => $request->process_type_id,
            'weight_kg'     => $request->weight_kg,
            'operator_name'     => $request->operator_name,
            'notes'     => $request->notes,
        ];

        // var_dump($data);

        // var_dump($waste_categoris);
        // exit;

        $waste_categoris->update($data);

        return redirect()
            ->route('waste_transaction.index')
            ->with('alert-success', 'Data berhasil diupdate.');
    }


    public function destroy(MasterLocations $location)
    {


        $location->delete();

        return redirect()
            ->route('waste_transaction.index')
            ->with('alert-success', 'Data berhasil dihapus.');
    }

    public function getData(Request $request)
    {
        if ($request->ajax()) {
            $data = WasteTransactions::select(
                'waste_transactions.*',
                'master_locations.name as nama_lokasi',
                'master_waste_categories.name as nama_kategori',
                'master_process_type.name_process_type',
            )
                ->join('master_locations', 'master_locations.id', '=', 'waste_transactions.location_id')
                ->join('master_waste_categories', 'master_waste_categories.id', '=', 'waste_transactions.category_id')
                ->join('master_process_type', 'master_process_type.id', '=', 'waste_transactions.process_type_id')
                ->orderBy('waste_transactions.id', 'desc')
                ->get();

            return Datatables::of($data)

                // Ubah format trx_date jadi dd/mm/yyyy
                ->editColumn('trx_date', function ($row) {
                    if (!$row->trx_date) {
                        return '-';
                    }
                    return Carbon::parse($row->trx_date)->format('d/m/Y');
                })

                ->addColumn('action', function ($row) {
                    $editRoute   = route('waste_transaction.edit', ['waste_transaction' => $row->id]);
                    $deleteRoute = route('waste_transaction.destroy', ['waste_transaction' => $row->id]);

                    $btn  = '<form method="POST" action="' . $deleteRoute . '" style="margin-left: 10px;" onsubmit="return confirm(\'Apakah anda yakin?\')">';
                    $btn .= '<div class="btn-group">';
                    $btn .= '<a href="' . $editRoute . '" class="btn btn-warning">Edit</a>';
                    $btn .= '<button type="submit" class="btn btn-danger ml-2">Hapus</button>';
                    $btn .= csrf_field();
                    $btn .= method_field("DELETE");
                    $btn .= '</div>';
                    $btn .= '</form>';

                    return $btn;
                })

                ->rawColumns(['action'])
                ->make(true);
        }
    }
}
