<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\MasterLocations;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Models\MasterWasteCatagories;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class WasteCatagoriesController extends Controller
{
    public function index()
    {
        return view('master.waste_categories.index');
    }

    public function create()
    {


        return view('master.waste_categories.create');
    }

    public function edit($id)
    {

        $data = MasterWasteCatagories::findOrFail($id);

        return view('master.waste_categories.edit', compact('data'));
    }





    public function store(Request $request)
    {
        // Ambil data text
        $data = [
            'name'     => $request->name,
            'color_hex' => $request->color_hex
        ];



        MasterWasteCatagories::create($data);

        return redirect()
            ->route('waste_categories.index')
            ->with('alert-success', 'Data berhasil disimpan.');
    }

    public function update(Request $request, $id)
    {
        $waste_categoris = MasterWasteCatagories::findOrFail($id);
        // Update field teks
        $data = [
            'name'     => $request->name,
            'color_hex' => $request->color_hex
        ];

        // var_dump($data);

        // var_dump($waste_categoris);
        // exit;

        $waste_categoris->update($data);

        return redirect()
            ->route('waste_categories.index')
            ->with('alert-success', 'Data berhasil diupdate.');
    }


    public function destroy(MasterLocations $location)
    {


        $location->delete();

        return redirect()
            ->route('waste_categories.index')
            ->with('alert-success', 'Data berhasil dihapus.');
    }

    public function getData(Request $request)
    {
        if ($request->ajax()) {
            $data = MasterWasteCatagories::select('master_waste_categories.*')
                ->orderBy('master_waste_categories.id', 'desc')
                ->get();

            return Datatables::of($data)
                // Kolom COLOR_HEX → tampilkan kotak + kode
                ->editColumn('color_hex', function ($row) {
                    if (!$row->color_hex) {
                        return '-';
                    }

                    $color = e($row->color_hex);

                    return '
                    <div style="display:flex;align-items:center;gap:8px;">
                        <span style="
                            display:inline-block;
                            width:20px;
                            height:20px;
                            border-radius:4px;
                            border:1px solid #ddd;
                            background-color: ' . $color . ';
                        "></span>
                        <span>' . $color . '</span>
                    </div>
                ';
                })

                // Kolom ACTION (punya kamu)
                ->addColumn('action', function ($row) {
                    $editRoute   = route('waste_categories.edit', ['waste_category' => $row->id]);
                    $deleteRoute = route('waste_categories.destroy', ['waste_category' => $row->id]);

                    $btn  = '<form method="POST" action="' . $deleteRoute . '" style="margin-left: 10px;" onsubmit="return confirm(\'Apakah anda yakin?\')">';
                    $btn .= '<div class="btn-group">';
                    $btn .= '<a href="' . $editRoute . '" class="btn btn-warning">Edit</a>';
                    $btn .= '<button type="submit" class="btn btn-danger ml-2">Hapus</button>';
                    $btn .= csrf_field();
                    $btn .= method_field("DELETE");
                    $btn .= '</div>';
                    $btn .= '</form>';

                    return $btn;
                })

                // tambahkan 'color_hex' ke rawColumns karena berisi HTML
                ->rawColumns(['action', 'color_hex'])
                ->make(true);
        }
    }


    public function apiIndex()
    {
        $data = MasterWasteCatagories::orderBy('no', 'asc')
            ->get()
            ->map(function ($item) {
                return [
                    'id'        => $item->id,
                    'name'        => $item->name,
                    'description'    => $item->description,
                    'created_at' => $item->created_at,
                    'updated_at' => $item->updated_at,
                ];
            });

        return response()->json([
            'status'  => true,
            'message' => 'List Locations',
            'data'    => $data,
        ]);
    }
}
