<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Models\MasterLocations;
use App\Models\MasterProcessType;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Models\MasterWasteCatagories;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class ProcessTypeController extends Controller
{
    public function index()
    {
        return view('master.process_type.index');
    }

    public function create()
    {


        return view('master.process_type.create');
    }

    public function edit($id)
    {

        $data = MasterProcessType::findOrFail($id);

        return view('master.process_type.edit', compact('data'));
    }





    public function store(Request $request)
    {
        // Ambil data text
        $data = [
            'name_process_type'     => $request->name_process_type
        ];



        MasterProcessType::create($data);

        return redirect()
            ->route('process_type.index')
            ->with('alert-success', 'Data berhasil disimpan.');
    }

    public function update(Request $request, $id)
    {
        $waste_categoris = MasterProcessType::findOrFail($id);
        // Update field teks
        $data = [
            'name_process_type'     => $request->name_process_type
        ];

        // var_dump($data);

        // var_dump($waste_categoris);
        // exit;

        $waste_categoris->update($data);

        return redirect()
            ->route('process_type.index')
            ->with('alert-success', 'Data berhasil diupdate.');
    }


    public function destroy(MasterLocations $location)
    {


        $location->delete();

        return redirect()
            ->route('process_type.index')
            ->with('alert-success', 'Data berhasil dihapus.');
    }

    public function getData(Request $request)
    {
        if ($request->ajax()) {
            $data = MasterProcessType::select('master_process_type.*')
                ->orderBy('master_process_type.id', 'desc')
                ->get();

            return Datatables::of($data)


                ->addColumn('action', function ($row) {
                    $editRoute   = route('process_type.edit', ['process_type' => $row->id]);
                    $deleteRoute = route('process_type.destroy', ['process_type' => $row->id]);

                    $btn  = '<form method="POST" action="' . $deleteRoute . '" style="margin-left: 10px;" onsubmit="return confirm(\'Apakah anda yakin?\')">';
                    $btn .= '<div class="btn-group">';
                    $btn .= '<a href="' . $editRoute . '" class="btn btn-warning">Edit</a>';
                    $btn .= '<button type="submit" class="btn btn-danger ml-2">Hapus</button>';
                    $btn .= csrf_field();
                    $btn .= method_field("DELETE");
                    $btn .= '</div>';
                    $btn .= '</form>';

                    return $btn;
                })

                // tambahkan 'color_hex' ke rawColumns karena berisi HTML
                ->rawColumns(['action'])
                ->make(true);
        }
    }
}
