<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class OrsRouteController extends Controller
{
    public function route()
    {
        // Koordinat FIX (lon,lat)
        $startLon = 109.221924;  // Purwokerto
        $startLat = -7.4191957;
        $endLon   = 109.0497126;  // TPST Jeruklegi
        $endLat   = -7.650166;

        // OSRM butuh format: lon,lat;lon,lat
        $coords = "{$startLon},{$startLat};{$endLon},{$endLat}";

        // ❗ PERHATIKAN: query string langsung di-embed, TIDAK pakai array parameter lagi
        $url = "https://routing.openstreetmap.de/routed-car/route/v1/driving/{$coords}"
            . "?overview=full&geometries=geojson&steps=false";

        // Kirim request ke OSRM
        $response = Http::get($url);

        if (! $response->successful()) {
            return response()->json([
                'error'  => 'Routing failed',
                'status' => $response->status(),
                'body'   => $response->json(),
            ], $response->status());
        }

        return $response->json();
    }
}
